/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.client.example;

import java.io.IOException;
import java.util.HashMap;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.ExecuteRequestBuilder;
import org.n52.wps.client.ExecuteResponseAnalyser;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;

public class WPSClientExample {
    public void testExecute() {
        ProcessDescriptionType describeProcessDocument;
        String wpsURL = "http://localhost:8080/wps/WebProcessingService";
        String processID = "org.n52.wps.server.algorithm.SimpleBufferAlgorithm";
        try {
            describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            System.out.println(describeProcessDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.requestGetCapabilities(wpsURL);
            describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("data", "http://geoprocessing.demo.52north.org:8080/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=topp:tasmania_roads&outputFormat=GML3");
            inputs.put("width", "0.05");
            IData data = this.executeProcess(wpsURL, processID, describeProcessDocument, inputs);
            if (data instanceof GTVectorDataBinding) {
                FeatureCollection featureCollection = ((GTVectorDataBinding)data).getPayload();
                System.out.println(featureCollection.size());
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        ProcessBriefType[] processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray();
        System.out.println("Processes in capabilities:");
        for (ProcessBriefType process : processList) {
            System.out.println(process.getIdentifier().getStringValue());
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        InputDescriptionType[] inputList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        for (InputDescriptionType input : inputList = processDescription.getDataInputs().getInputArray()) {
            System.out.println(input.getIdentifier().getStringValue());
        }
        return processDescription;
    }

    public IData executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, Object> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String inputName = input.getIdentifier().getStringValue();
            Object inputValue = inputs.get(inputName);
            if (input.getLiteralData() != null) {
                if (!(inputValue instanceof String)) continue;
                executeBuilder.addLiteralData(inputName, (String)inputValue);
                continue;
            }
            if (input.getComplexData() == null) continue;
            if (inputValue instanceof FeatureCollection) {
                GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
            }
            if (inputValue instanceof String) {
                executeBuilder.addComplexDataReference(inputName, (String)inputValue, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
            }
            if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
            throw new IOException("Property not set, but mandatory: " + inputName);
        }
        executeBuilder.setMimeTypeForOutput("text/xml", "result");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "result");
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            IData data = analyser.getComplexDataByIndex(0, GTVectorDataBinding.class);
            return data;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public static void main(String[] args) {
        WPSClientExample client = new WPSClientExample();
        client.testExecute();
    }
}

