/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.client.example;

import java.io.IOException;
import java.util.Random;
import javax.xml.transform.TransformerException;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.n52.wps.client.ExecuteRequestBuilder;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.w3c.dom.Node;

public class EchoProcessExample {
    private String url = "http://localhost:8080/wps/WebProcessingService";
    private String processID = "org.n52.wps.server.algorithm.test.EchoProcess";
    private Random rand = new Random();

    public static void main(String[] args) {
        EchoProcessExample example = new EchoProcessExample();
        try {
            example.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void run() throws IOException, WPSClientException, TransformerException {
        ExecuteResponseDocument responseDoc;
        XObject data;
        String output;
        System.out.println("EchoProcess Example");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        boolean connected = wpsClient.connect(this.url);
        if (!connected) {
            System.out.println("Could not connect to WPS.");
            return;
        }
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(this.url, this.processID);
        System.out.println("Echo process description:\n" + processDescription.xmlText() + "\n");
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        String input = "Hello lucky number " + this.rand.nextInt(42) + "!";
        String parameterIn = "literalInput";
        executeBuilder.addLiteralData(parameterIn, input);
        String parameterOut = "literalOutput";
        executeBuilder.setResponseDocument(parameterOut, null, null, null);
        if (!executeBuilder.isExecuteValid()) {
            System.out.println("Created execute request is NOT valid.");
        }
        ExecuteDocument executeRequest = executeBuilder.getExecute();
        System.out.println("Sending execute request:\n" + executeRequest.xmlText() + "\n");
        Object response = wpsClient.execute(this.url, executeRequest);
        System.out.println("Got response:\n" + response.toString() + "\n");
        if (response instanceof ExecuteResponseDocument && (output = (data = XPathAPI.eval((Node)(responseDoc = (ExecuteResponseDocument)response).getDomNode(), (String)"//wps:LiteralData")).toString()).equals(input)) {
            System.out.println("Echo received!");
        }
    }
}

