/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.OperationDocument;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.client.ClientCapabiltiesRequest;
import org.n52.wps.client.ClientDescribeProcessRequest;
import org.n52.wps.client.WPSClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WPSClientSession {
    private static Logger LOGGER = LoggerFactory.getLogger(WPSClientSession.class);
    private static final String OGC_OWS_URI = "http://www.opengeospatial.net/ows";
    private static String SUPPORTED_VERSION = "1.0.0";
    private static WPSClientSession session;
    private Map<String, CapabilitiesDocument> loggedServices;
    private XmlOptions options = new XmlOptions();
    private Map<String, ProcessDescriptionsDocument> processDescriptions;

    private WPSClientSession() {
        this.options.setLoadStripWhitespace();
        this.options.setLoadTrimTextBuffer();
        this.loggedServices = new HashMap<String, CapabilitiesDocument>();
        this.processDescriptions = new HashMap<String, ProcessDescriptionsDocument>();
    }

    public static WPSClientSession getInstance() {
        if (session == null) {
            session = new WPSClientSession();
        }
        return session;
    }

    public static void reset() {
        session = new WPSClientSession();
    }

    public boolean connect(String url) throws WPSClientException {
        ProcessDescriptionsDocument processDescs;
        LOGGER.info("CONNECT");
        if (this.loggedServices.containsKey(url)) {
            LOGGER.info("Service already registered: " + url);
            return false;
        }
        CapabilitiesDocument capsDoc = this.retrieveCapsViaGET(url);
        if (capsDoc != null) {
            this.loggedServices.put(url, this.retrieveCapsViaGET(url));
        }
        if ((processDescs = this.describeAllProcesses(url)) != null && capsDoc != null) {
            this.processDescriptions.put(url, processDescs);
            return true;
        }
        LOGGER.warn("retrieving caps failed, caps are null");
        return false;
    }

    public void disconnect(String url) {
        if (this.loggedServices.containsKey(url)) {
            this.loggedServices.remove(url);
            this.processDescriptions.remove(url);
            LOGGER.info("service removed successfully: " + url);
        }
    }

    public List<String> getLoggedServices() {
        return new ArrayList<String>(this.loggedServices.keySet());
    }

    public boolean descriptionsAvailableInCache(String serverID) {
        return this.processDescriptions.containsKey(serverID);
    }

    private ProcessDescriptionsDocument getProcessDescriptionsFromCache(String wpsUrl) throws IOException {
        if (!this.descriptionsAvailableInCache(wpsUrl)) {
            try {
                this.connect(wpsUrl);
            }
            catch (WPSClientException e) {
                throw new IOException("Could not initialize WPS " + wpsUrl);
            }
        }
        return this.processDescriptions.get(wpsUrl);
    }

    public ProcessDescriptionType getProcessDescription(String serverID, String processID) throws IOException {
        ProcessDescriptionType[] processes;
        for (ProcessDescriptionType process : processes = this.getProcessDescriptionsFromCache(serverID).getProcessDescriptions().getProcessDescriptionArray()) {
            if (!process.getIdentifier().getStringValue().equals(processID)) continue;
            return process;
        }
        return null;
    }

    public ProcessDescriptionType[] getAllProcessDescriptions(String wpsUrl) throws IOException {
        return this.getProcessDescriptionsFromCache(wpsUrl).getProcessDescriptions().getProcessDescriptionArray();
    }

    public boolean serviceAlreadyRegistered(String serverID) {
        return this.loggedServices.containsKey(serverID);
    }

    public CapabilitiesDocument getWPSCaps(String url) {
        return this.loggedServices.get(url);
    }

    public ProcessDescriptionsDocument describeAllProcesses(String url) throws WPSClientException {
        CapabilitiesDocument doc = this.loggedServices.get(url);
        if (doc == null) {
            LOGGER.warn("serviceCaps are null, perhaps server does not exist");
            return null;
        }
        ProcessBriefType[] processes = doc.getCapabilities().getProcessOfferings().getProcessArray();
        String[] processIDs = new String[processes.length];
        for (int i = 0; i < processIDs.length; ++i) {
            processIDs[i] = processes[i].getIdentifier().getStringValue();
        }
        return this.describeProcess(processIDs, url);
    }

    public ProcessDescriptionsDocument describeProcess(String[] processIDs, String serverID) throws WPSClientException {
        CapabilitiesDocument caps = this.loggedServices.get(serverID);
        OperationDocument.Operation[] operations = caps.getCapabilities().getOperationsMetadata().getOperationArray();
        String url = null;
        for (OperationDocument.Operation operation : operations) {
            if (!operation.getName().equals("DescribeProcess")) continue;
            url = operation.getDCPArray()[0].getHTTP().getGetArray()[0].getHref();
        }
        if (url == null) {
            throw new WPSClientException("Missing DescribeOperation in Capabilities");
        }
        return this.retrieveDescriptionViaGET(processIDs, url);
    }

    private Object execute(String serverID, ExecuteDocument execute, boolean rawData) throws WPSClientException {
        CapabilitiesDocument caps = this.loggedServices.get(serverID);
        OperationDocument.Operation[] operations = caps.getCapabilities().getOperationsMetadata().getOperationArray();
        String url = null;
        for (OperationDocument.Operation operation : operations) {
            if (!operation.getName().equals("Execute")) continue;
            url = operation.getDCPArray()[0].getHTTP().getPostArray()[0].getHref();
        }
        if (url == null) {
            throw new WPSClientException("Caps does not contain any information about the entry point for process execution");
        }
        execute.getExecute().setVersion(SUPPORTED_VERSION);
        return this.retrieveExecuteResponseViaPOST(url, execute, rawData);
    }

    public Object execute(String serverID, ExecuteDocument execute) throws WPSClientException {
        if (execute.getExecute().isSetResponseForm() && execute.getExecute().isSetResponseForm() && execute.getExecute().getResponseForm().isSetRawDataOutput()) {
            return this.execute(serverID, execute, true);
        }
        return this.execute(serverID, execute, false);
    }

    private CapabilitiesDocument retrieveCapsViaGET(String url) throws WPSClientException {
        ClientCapabiltiesRequest req = new ClientCapabiltiesRequest();
        url = req.getRequest(url);
        try {
            URL urlObj = new URL(url);
            urlObj.getContent();
            InputStream is = urlObj.openStream();
            Document doc = this.checkInputStream(is);
            return CapabilitiesDocument.Factory.parse((Node)doc, (XmlOptions)this.options);
        }
        catch (MalformedURLException e) {
            throw new WPSClientException("Capabilities URL seems to be unvalid: " + url, e);
        }
        catch (IOException e) {
            throw new WPSClientException("Error occured while retrieving capabilities from url: " + url, e);
        }
        catch (XmlException e) {
            throw new WPSClientException("Error occured while parsing XML", (Exception)((Object)e));
        }
    }

    private ProcessDescriptionsDocument retrieveDescriptionViaGET(String[] processIDs, String url) throws WPSClientException {
        ClientDescribeProcessRequest req = new ClientDescribeProcessRequest();
        req.setIdentifier(processIDs);
        String requestURL = req.getRequest(url);
        try {
            URL urlObj = new URL(requestURL);
            InputStream is = urlObj.openStream();
            Document doc = this.checkInputStream(is);
            return ProcessDescriptionsDocument.Factory.parse((Node)doc, (XmlOptions)this.options);
        }
        catch (MalformedURLException e) {
            throw new WPSClientException("URL seems not to be valid", e);
        }
        catch (IOException e) {
            throw new WPSClientException("Error occured while receiving data", e);
        }
        catch (XmlException e) {
            throw new WPSClientException("Error occured while parsing ProcessDescription document", (Exception)((Object)e));
        }
    }

    private InputStream retrieveDataViaPOST(XmlObject obj, String urlString) throws WPSClientException {
        try {
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept-Encoding", "gzip");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setDoOutput(true);
            obj.save(conn.getOutputStream());
            InputStream input = null;
            String encoding = conn.getContentEncoding();
            input = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
            return input;
        }
        catch (MalformedURLException e) {
            throw new WPSClientException("URL seems to be unvalid", e);
        }
        catch (IOException e) {
            throw new WPSClientException("Error while transmission", e);
        }
    }

    private Document checkInputStream(InputStream is) throws WPSClientException {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setNamespaceAware(true);
        try {
            Document doc = fac.newDocumentBuilder().parse(is);
            if (this.getFirstElementNode(doc.getFirstChild()).getLocalName().equals("ExceptionReport") && this.getFirstElementNode(doc.getFirstChild()).getNamespaceURI().equals(OGC_OWS_URI)) {
                try {
                    ExceptionReportDocument exceptionDoc = ExceptionReportDocument.Factory.parse((Node)doc);
                    LOGGER.debug(exceptionDoc.xmlText(this.options));
                    throw new WPSClientException("Error occured while executing query", exceptionDoc);
                }
                catch (XmlException e) {
                    throw new WPSClientException("Error while parsing ExceptionReport retrieved from server", (Exception)((Object)e));
                }
            }
            return doc;
        }
        catch (SAXException e) {
            throw new WPSClientException("Error while parsing input.", e);
        }
        catch (IOException e) {
            throw new WPSClientException("Error occured while transfer", e);
        }
        catch (ParserConfigurationException e) {
            throw new WPSClientException("Error occured, parser is not correctly configured", e);
        }
    }

    private Node getFirstElementNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return node;
        }
        return this.getFirstElementNode(node.getNextSibling());
    }

    private Object retrieveExecuteResponseViaPOST(String url, ExecuteDocument doc, boolean rawData) throws WPSClientException {
        InputStream is = this.retrieveDataViaPOST((XmlObject)doc, url);
        if (rawData) {
            return is;
        }
        Document documentObj = this.checkInputStream(is);
        ExceptionReportDocument erDoc = null;
        try {
            return ExecuteResponseDocument.Factory.parse((Node)documentObj);
        }
        catch (XmlException e) {
            try {
                erDoc = ExceptionReportDocument.Factory.parse((Node)documentObj);
            }
            catch (XmlException e1) {
                throw new WPSClientException("Error occured while parsing executeResponse", (Exception)((Object)e));
            }
            return erDoc;
        }
    }

    public String[] getProcessNames(String url) throws IOException {
        ProcessDescriptionType[] processes = this.getProcessDescriptionsFromCache(url).getProcessDescriptions().getProcessDescriptionArray();
        String[] processNames = new String[processes.length];
        for (int i = 0; i < processNames.length; ++i) {
            processNames[i] = processes[i].getIdentifier().getStringValue();
        }
        return processNames;
    }

    public Object executeViaGET(String url, String executeAsGETString) throws WPSClientException {
        url = url + executeAsGETString;
        try {
            URL urlObj = new URL(url);
            InputStream is = urlObj.openStream();
            if (executeAsGETString.toUpperCase().contains("RAWDATA")) {
                return is;
            }
            Document doc = this.checkInputStream(is);
            ExceptionReportDocument erDoc = null;
            try {
                return ExecuteResponseDocument.Factory.parse((Node)doc);
            }
            catch (XmlException e) {
                try {
                    erDoc = ExceptionReportDocument.Factory.parse((Node)doc);
                }
                catch (XmlException e1) {
                    throw new WPSClientException("Error occured while parsing executeResponse", (Exception)((Object)e));
                }
                throw new WPSClientException("Error occured while parsing executeResponse", erDoc);
            }
        }
        catch (MalformedURLException e) {
            throw new WPSClientException("Capabilities URL seems to be unvalid: " + url, e);
        }
        catch (IOException e) {
            throw new WPSClientException("Error occured while retrieving capabilities from url: " + url, e);
        }
    }
}

