/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.opengis.examples.packet.GMLPacketDocument;
import net.opengis.examples.packet.PropertyType;
import net.opengis.examples.packet.StaticFeatureType;
import net.opengis.gml.CoordType;
import net.opengis.gml.LineStringPropertyType;
import net.opengis.gml.LinearRingMemberType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.PointPropertyType;
import net.opengis.gml.PolygonPropertyType;
import org.apache.xmlbeans.XmlException;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGMLParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(SimpleGMLParser.class);
    private SimpleFeatureType type;
    private SimpleFeatureBuilder featureBuilder;
    private GeometryFactory geomFactory;

    public SimpleGMLParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        this.geomFactory = new GeometryFactory();
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        GMLPacketDocument doc;
        try {
            doc = GMLPacketDocument.Factory.parse((InputStream)stream);
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("Error while parsing XML", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error transfering XML", e);
        }
        if (doc != null) {
            return this.parseXML(doc);
        }
        return null;
    }

    private GTVectorDataBinding parseXML(GMLPacketDocument doc) {
        int numberOfMembers = doc.getGMLPacket().getPacketMemberArray().length;
        ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
        for (int i = 0; i < numberOfMembers; ++i) {
            SimpleFeature newFeature;
            StaticFeatureType feature = doc.getGMLPacket().getPacketMemberArray(i).getStaticFeature();
            if (i == 0) {
                this.type = this.createFeatureType(feature);
                this.featureBuilder = new SimpleFeatureBuilder(this.type);
            }
            if ((newFeature = this.convertStaticFeature(feature)) != null) {
                simpleFeatureList.add(newFeature);
                continue;
            }
            LOGGER.debug("feature has no geometry, feature will not be included in featureCollection");
        }
        ListFeatureCollection collection = new ListFeatureCollection(this.type, simpleFeatureList);
        return new GTVectorDataBinding((FeatureCollection<?, ?>)collection);
    }

    private SimpleFeature convertStaticFeature(StaticFeatureType staticFeature) {
        SimpleFeature feature = null;
        Geometry geom = null;
        if (staticFeature.isSetLineStringProperty()) {
            geom = this.convertToJTSGeometry(staticFeature.getLineStringProperty());
        } else if (staticFeature.isSetPointProperty()) {
            geom = this.convertToJTSGeometry(staticFeature.getPointProperty());
        } else if (staticFeature.isSetPolygonProperty()) {
            geom = this.convertToJTSGeometry(staticFeature.getPolygonProperty());
        }
        if (geom == null) {
            return null;
        }
        if (this.type.getAttributeCount() > 1) {
            if (staticFeature.sizeOfPropertyArray() > 0) {
                ArrayList<Object> properties = new ArrayList<Object>(staticFeature.sizeOfPropertyArray());
                properties.add(geom);
                for (int i = 0; i < staticFeature.sizeOfPropertyArray(); ++i) {
                    PropertyType ptype = staticFeature.getPropertyArray(i);
                    if (ptype.getPropertyName().contains("geom")) continue;
                    PropertyType.Value v = ptype.getValue();
                    properties.add(v.getStringValue());
                }
                feature = this.featureBuilder.buildFeature(staticFeature.getFid(), properties.toArray());
            }
        } else {
            feature = this.featureBuilder.buildFeature(staticFeature.getFid(), new Object[]{geom});
        }
        return feature;
    }

    private SimpleFeatureType createFeatureType(StaticFeatureType staticFeature) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("gmlPacketFeatures");
        if (staticFeature.isSetLineStringProperty()) {
            typeBuilder.add("LineString", LineString.class);
        } else if (staticFeature.isSetPointProperty()) {
            typeBuilder.add("Point", Point.class);
        } else if (staticFeature.isSetPolygonProperty()) {
            typeBuilder.add("Polygon", Polygon.class);
        }
        if (staticFeature.sizeOfPropertyArray() > 0) {
            for (int i = 0; i < staticFeature.sizeOfPropertyArray(); ++i) {
                PropertyType type = staticFeature.getPropertyArray(i);
                if (type.getPropertyName().contains("geom")) continue;
                typeBuilder.add(type.getPropertyName(), String.class);
            }
        }
        return typeBuilder.buildFeatureType();
    }

    private Geometry convertToJTSGeometry(LineStringPropertyType lineString) {
        Coordinate[] coords;
        if (lineString.getLineString().getCoordArray().length != 0) {
            CoordType[] xmlCoords = lineString.getLineString().getCoordArray();
            coords = this.convertToJTSCoordinates(xmlCoords);
            if (coords.length == 0) {
                LOGGER.debug("feature does not include any geometry (LineString)");
                return null;
            }
        } else {
            if (lineString.getLineString().isSetCoordinates()) {
                throw new IllegalArgumentException("Element gml:coordinates is not supported yet");
            }
            LOGGER.debug("LineString has no coordinates");
            return null;
        }
        LineString geom = this.geomFactory.createLineString(coords);
        return geom;
    }

    private Geometry convertToJTSGeometry(PointPropertyType point) {
        Coordinate coord = this.convertToJTSCoordinate(point.getPoint().getCoord());
        return this.geomFactory.createPoint(coord);
    }

    private Geometry convertToJTSGeometry(PolygonPropertyType polygon) {
        LinearRingType outerRing = polygon.getPolygon().getOuterBoundaryIs().getLinearRing();
        LinearRing jtsOuterRing = this.convertToJTSLinearRing(outerRing);
        LinearRingMemberType[] innerRings = polygon.getPolygon().getInnerBoundaryIsArray();
        ArrayList<LinearRing> jtsInnerRings = new ArrayList<LinearRing>();
        for (LinearRingMemberType ring : innerRings) {
            if (ring.getLinearRing() == null) continue;
            jtsInnerRings.add(this.convertToJTSLinearRing(ring.getLinearRing()));
        }
        return this.geomFactory.createPolygon(jtsOuterRing, jtsInnerRings.toArray(new LinearRing[jtsInnerRings.size()]));
    }

    private LinearRing convertToJTSLinearRing(LinearRingType linearRing) {
        Coordinate[] coords = this.convertToJTSCoordinates(linearRing.getCoordArray());
        return this.geomFactory.createLinearRing(coords);
    }

    private Coordinate[] convertToJTSCoordinates(CoordType[] coords) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        for (CoordType coord : coords) {
            Coordinate coordinate = this.convertToJTSCoordinate(coord);
            coordList.add(coordinate);
        }
        return coordList.toArray(new Coordinate[coordList.size()]);
    }

    private Coordinate convertToJTSCoordinate(CoordType coord) {
        if (!coord.isSetZ()) {
            return new Coordinate(coord.getX().doubleValue(), coord.getY().doubleValue());
        }
        return new Coordinate(coord.getX().doubleValue(), coord.getY().doubleValue(), coord.getZ().doubleValue());
    }
}

