/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.kml.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML3BasicParser;

public class KMLParser
extends AbstractParser {
    public KMLParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile("kml", "tmp");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GTVectorDataBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    private GTVectorDataBinding parseXML(File file) {
        KMLConfiguration configuration = new KMLConfiguration();
        SimpleFeatureCollection fc = new GML3BasicParser().parseFeatureCollection(file, (Configuration)configuration, true);
        GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection<?, ?>)fc);
        return data;
    }
}

