/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotiffZippedParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GeotiffZippedParser.class);

    public GeotiffZippedParser() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
    }

    public GTRasterDataBinding parse(InputStream input, String mimeType, String schema) {
        try {
            File zippedFile = IOUtils.writeStreamToFile((InputStream)input, (String)"zip");
            this.finalizeFiles.add(zippedFile);
            List files = IOUtils.unzipAll((File)zippedFile);
            this.finalizeFiles.addAll(files);
            for (File file : files) {
                if (!file.getName().toLowerCase().endsWith(".tif") && !file.getName().toLowerCase().endsWith(".tiff")) continue;
                return this.parseTiff(file);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception while trying to unzip tiff.", (Throwable)e);
        }
        throw new RuntimeException("Could not parse zipped geotiff.");
    }

    private GTRasterDataBinding parseTiff(File file) {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        try {
            GeoTiffReader reader = new GeoTiffReader((Object)file, hints);
            GridCoverage2D coverage = reader.read(null);
            return new GTRasterDataBinding(coverage);
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to create GTRasterDataBinding out of tiff.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

