/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotiffParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GeotiffParser.class);

    public GeotiffParser() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
    }

    public GTRasterDataBinding parse(InputStream input, String mimeType, String schema) {
        File tempFile;
        try {
            int len;
            tempFile = File.createTempFile("tempfile" + UUID.randomUUID(), "tmp");
            this.finalizeFiles.add(tempFile);
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            byte[] buf = new byte[4096];
            while ((len = input.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
            outputStream.close();
            input.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            throw new RuntimeException(e1);
        }
        return this.parseTiff(tempFile);
    }

    private GTRasterDataBinding parseTiff(File file) {
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0x10000000L);
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        try {
            GeoTiffReader reader = new GeoTiffReader((Object)file, hints);
            GridCoverage2D coverage = reader.read(null);
            return new GTRasterDataBinding(coverage);
        }
        catch (DataSourceException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

