/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.complex.JTSGeometryBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJSONParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GeoJSONParser.class);

    public GeoJSONParser() {
        this.supportedIDataTypes.add(JTSGeometryBinding.class);
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IData parse(InputStream input, String mimeType, String schema) {
        GeometryCollection g;
        String geojsonstring = "";
        String line = "";
        BufferedReader breader = new BufferedReader(new InputStreamReader(input));
        try {
            while ((line = breader.readLine()) != null) {
                geojsonstring = geojsonstring.concat(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception while reading inputstream.", (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (geojsonstring.contains("FeatureCollection")) {
            try {
                FeatureCollection featureCollection = new FeatureJSON().readFeatureCollection((Object)geojsonstring);
                return new GTVectorDataBinding(featureCollection);
            }
            catch (IOException e) {
                LOGGER.info("Could not read FeatureCollection from inputstream");
            }
        } else if (geojsonstring.contains("Feature")) {
            try {
                SimpleFeature feature = new FeatureJSON().readFeature((Object)geojsonstring);
                ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>();
                featureList.add(feature);
                ListFeatureCollection featureCollection = new ListFeatureCollection(feature.getFeatureType(), featureList);
                return new GTVectorDataBinding((FeatureCollection<?, ?>)featureCollection);
            }
            catch (IOException e) {
                LOGGER.info("Could not read Feature from inputstream");
            }
        } else if (geojsonstring.contains("GeometryCollection")) {
            try {
                g = new GeometryJSON().readGeometryCollection((Object)geojsonstring);
                return new JTSGeometryBinding((Geometry)g);
            }
            catch (IOException e) {
                LOGGER.info("Could not read GeometryCollection from inputstream.");
            }
        } else if (geojsonstring.contains("Point") || geojsonstring.contains("LineString") || geojsonstring.contains("Polygon") || geojsonstring.contains("MultiPoint") || geojsonstring.contains("MultiLineString") || geojsonstring.contains("MultiPolygon")) {
            try {
                g = new GeometryJSON().read((Object)geojsonstring);
                return new JTSGeometryBinding((Geometry)g);
            }
            catch (IOException e) {
                LOGGER.info("Could not read single Geometry from inputstream.");
            }
        }
        LOGGER.error("Could not parse inputstream, returning null.");
        return null;
    }
}

