/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.CRS;
import org.n52.wps.io.GTHelper;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTBinZippedWKT64Parser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GTBinZippedWKT64Parser.class);

    public GTBinZippedWKT64Parser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        try {
            String fileName = "tempfile" + UUID.randomUUID() + ".zip";
            String tmpDirPath = System.getProperty("java.io.tmpdir");
            File tempFile = new File(tmpDirPath + File.separatorChar + fileName);
            this.finalizeFiles.add(tempFile);
            try {
                int len;
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                byte[] buf = new byte[4096];
                while ((len = stream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.close();
                stream.close();
            }
            catch (FileNotFoundException e) {
                System.gc();
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                System.gc();
                throw new RuntimeException(e);
            }
            this.finalizeFiles.add(tempFile);
            stream.close();
            List wktFiles = IOUtils.unzip((File)tempFile, (String)"wkt");
            this.finalizeFiles.addAll(wktFiles);
            if (wktFiles == null || wktFiles.size() == 0) {
                throw new RuntimeException("Cannot find a shapefile inside the zipped file.");
            }
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            for (int i = 0; i < wktFiles.size(); ++i) {
                File wktFile = (File)wktFiles.get(i);
                FileReader fileReader = new FileReader(wktFile);
                WKTReader2 wktReader = new WKTReader2();
                Geometry geometry = wktReader.read((Reader)fileReader);
                geometries.add(geometry);
            }
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
            SimpleFeatureCollection inputFeatureCollection = this.createFeatureCollection(geometries, coordinateReferenceSystem);
            return new GTVectorDataBinding((FeatureCollection<?, ?>)inputFeatureCollection);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (FactoryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
    }

    private SimpleFeatureCollection createFeatureCollection(List<Geometry> geometries, CoordinateReferenceSystem coordinateReferenceSystem) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        if (coordinateReferenceSystem == null) {
            try {
                coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
            }
            catch (NoSuchAuthorityCodeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("An error has occurred while trying to decode CRS EPSG:4326", e);
            }
            catch (FactoryException e) {
                LOGGER.error(e.getMessage());
                throw new RuntimeException("An error has occurred while trying to decode CRS EPSG:432", e);
            }
            typeBuilder.setCRS(coordinateReferenceSystem);
        }
        String namespace = "http://www.opengis.net/gml";
        typeBuilder.setNamespaceURI(namespace);
        NameImpl nameType = new NameImpl(namespace, "Feature");
        typeBuilder.setName((Name)nameType);
        typeBuilder.add("GEOMETRY", geometries.get(0).getClass());
        ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        for (int i = 0; i < geometries.size(); ++i) {
            SimpleFeature feature = GTHelper.createFeature("" + i, geometries.get(i), featureType, new ArrayList<Property>());
            simpleFeatureList.add(feature);
        }
        ListFeatureCollection collection = new ListFeatureCollection(featureType, simpleFeatureList);
        return collection;
    }
}

