/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;

public class GTBinZippedSHPParser
extends AbstractParser {
    public GTBinZippedSHPParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        try {
            String fileName = "tempfile" + UUID.randomUUID() + ".zip";
            String tmpDirPath = System.getProperty("java.io.tmpdir");
            File tempFile = new File(tmpDirPath + File.separatorChar + fileName);
            this.finalizeFiles.add(tempFile);
            try {
                int len;
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                byte[] buf = new byte[4096];
                while ((len = stream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.close();
                stream.close();
            }
            catch (FileNotFoundException e) {
                System.gc();
                throw new RuntimeException(e);
            }
            catch (IOException e1) {
                System.gc();
                throw new RuntimeException(e1);
            }
            File shp = (File)IOUtils.unzip((File)tempFile, (String)"shp").get(0);
            ShapefileDataStore store = new ShapefileDataStore(shp.toURI().toURL());
            SimpleFeatureCollection features = store.getFeatureSource(store.getTypeNames()[0]).getFeatures();
            System.gc();
            return new GTVectorDataBinding((FeatureCollection<?, ?>)features);
        }
        catch (IOException e) {
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
    }
}

