/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.data.GenericFileDataWithGT;
import org.n52.wps.io.data.binding.complex.GenericFileDataWithGTBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML3BasicParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GML3BasicParser4Files
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GML3BasicParser4Files.class);

    public GML3BasicParser4Files() {
        this.supportedIDataTypes.add(GenericFileDataWithGTBinding.class);
    }

    public GenericFileDataWithGTBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".gml3");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GenericFileDataWithGTBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    private GenericFileDataWithGTBinding parseXML(File file) {
        SimpleFeatureCollection fc = new GML3BasicParser().parseFeatureCollection(file);
        GenericFileDataWithGTBinding data = null;
        try {
            data = new GenericFileDataWithGTBinding(new GenericFileDataWithGT((FeatureCollection<?, ?>)fc));
        }
        catch (IOException e) {
            LOGGER.error("Exception while creating GenericFileData from FeatureCollection", (Throwable)e);
        }
        return data;
    }
}

