/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML2Handler;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class GML3BasicParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GML3BasicParser.class);

    public GML3BasicParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile("wps", "tmp");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GTVectorDataBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    public GTVectorDataBinding parse(File file, String mimeType, String schema) {
        return this.parseXML(file);
    }

    private GTVectorDataBinding parseXML(File file) {
        SimpleFeatureCollection fc = this.parseFeatureCollection(file);
        GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection<?, ?>)fc);
        return data;
    }

    public SimpleFeatureCollection parseFeatureCollection(File file) {
        QName schematypeTuple = this.determineFeatureTypeSchema(file);
        boolean schemaLocationIsRelative = false;
        if (!schematypeTuple.getLocalPart().contains("://") && !schematypeTuple.getLocalPart().contains("file:")) {
            schemaLocationIsRelative = true;
        }
        GMLConfiguration configuration = null;
        boolean shouldSetParserStrict = true;
        if (schematypeTuple != null) {
            String schemaLocation = schematypeTuple.getLocalPart();
            if (schemaLocationIsRelative) {
                schemaLocation = new File(file.getParentFile(), schemaLocation).getAbsolutePath();
            }
            if (schemaLocation.equals("http://schemas.opengis.net/gml/3.1.1/base/gml.xsd")) {
                configuration = new GMLConfiguration();
                shouldSetParserStrict = false;
            } else if (schemaLocation != null && schematypeTuple.getNamespaceURI() != null) {
                SchemaRepository.registerSchemaLocation((String)schematypeTuple.getNamespaceURI(), (String)schemaLocation);
                configuration = new ApplicationSchemaConfiguration(schematypeTuple.getNamespaceURI(), schemaLocation);
            } else {
                configuration = new GMLConfiguration();
                shouldSetParserStrict = false;
            }
        }
        Parser parser = new Parser(configuration);
        parser.setStrict(shouldSetParserStrict);
        SimpleFeatureCollection fc = this.parseFeatureCollection(file, (Configuration)configuration, shouldSetParserStrict);
        return fc;
    }

    public SimpleFeatureCollection parseFeatureCollection(File file, Configuration configuration, boolean shouldSetParserStrict) {
        Parser parser = new Parser(configuration);
        parser.setStrict(shouldSetParserStrict);
        SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
        try {
            Object parsedData = parser.parse((InputStream)new FileInputStream(file));
            if (parsedData instanceof FeatureCollection) {
                fc = (SimpleFeatureCollection)parsedData;
            } else if (parsedData instanceof HashMap) {
                ArrayList possibleSimpleFeatureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                if (possibleSimpleFeatureList != null) {
                    ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
                    SimpleFeatureType sft = null;
                    for (Object possibleSimpleFeature : possibleSimpleFeatureList) {
                        if (!(possibleSimpleFeature instanceof SimpleFeature)) continue;
                        SimpleFeature sf = (SimpleFeature)possibleSimpleFeature;
                        if (sft == null) {
                            sft = sf.getType();
                        }
                        simpleFeatureList.add(sf);
                    }
                    fc = new ListFeatureCollection(sft, simpleFeatureList);
                } else {
                    fc = (SimpleFeatureCollection)((HashMap)parsedData).get("FeatureCollection");
                }
            } else if (parsedData instanceof SimpleFeature) {
                Collection values = ((SimpleFeature)parsedData).getValue();
                for (Property value : values) {
                    Object tempValue = value.getValue();
                    if (!value.getType().getBinding().isAssignableFrom(FeatureCollection.class) || !(tempValue instanceof ArrayList)) continue;
                    ArrayList list = (ArrayList)tempValue;
                    ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
                    SimpleFeatureType sft = null;
                    for (Object listValue : list) {
                        if (!(listValue instanceof SimpleFeature)) continue;
                        SimpleFeature sf = (SimpleFeature)listValue;
                        if (sft == null) {
                            sft = sf.getType();
                        }
                        simpleFeatureList.add(sf);
                    }
                    fc = new ListFeatureCollection(sft, simpleFeatureList);
                }
            }
            SimpleFeatureIterator featureIterator = fc.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                if (feature.getDefaultGeometry() != null) continue;
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    try {
                        Geometry g = (Geometry)property.getValue();
                        if (g == null) continue;
                        GeometryAttribute oldGeometryDescriptor = feature.getDefaultGeometryProperty();
                        GeometryTypeImpl type = new GeometryTypeImpl(property.getName(), oldGeometryDescriptor.getType().getBinding(), oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                        GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type, property.getName(), 0, 1, true, null);
                        GmlObjectIdImpl identifier = new GmlObjectIdImpl(feature.getID());
                        GeometryAttributeImpl geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                        feature.setDefaultGeometryProperty((GeometryAttribute)geo);
                        feature.setDefaultGeometry((Object)g);
                    }
                    catch (ClassCastException e) {}
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while handling parsed GML.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return fc;
    }

    private QName determineFeatureTypeSchema(File file) {
        try {
            GML2Handler handler = new GML2Handler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse((InputStream)new FileInputStream(file), (DefaultHandler)handler);
            String schemaUrl = handler.getSchemaUrl();
            if (schemaUrl == null) {
                return null;
            }
            String namespaceURI = handler.getNameSpaceURI();
            return new QName(namespaceURI, schemaUrl);
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to determine schema of FeatureType.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

