/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML2Handler;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GML32BasicParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GML32BasicParser.class);
    private Configuration configuration;

    public GML32BasicParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile("wps", "tmp");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            QName schematypeTuple = this.determineFeatureTypeSchema(tempFile);
            return this.parse(new FileInputStream(tempFile), schematypeTuple);
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    public GTVectorDataBinding parse(InputStream input, QName schematypeTuple) {
        if (this.configuration == null) {
            this.configuration = this.resolveConfiguration(schematypeTuple);
        }
        Parser parser = new Parser(this.configuration);
        parser.setStrict(true);
        FeatureCollection fc = this.resolveFeatureCollection(parser, input);
        GTVectorDataBinding data = new GTVectorDataBinding(fc);
        return data;
    }

    private FeatureCollection resolveFeatureCollection(Parser parser, InputStream input) {
        FeatureCollection fc = null;
        try {
            Object parsedData = parser.parse(input);
            if (parsedData instanceof FeatureCollection) {
                fc = (FeatureCollection)parsedData;
            } else {
                ArrayList featureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                if (featureList != null) {
                    for (SimpleFeature feature : featureList) {
                        fc.add((Feature)feature);
                    }
                } else {
                    fc = (FeatureCollection)((Map)parsedData).get("FeatureCollection");
                }
            }
            FeatureIterator featureIterator = fc.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                if (feature.getDefaultGeometry() != null) continue;
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    try {
                        Geometry g = (Geometry)property.getValue();
                        if (g == null) continue;
                        GeometryAttribute oldGeometryDescriptor = feature.getDefaultGeometryProperty();
                        GeometryTypeImpl type = new GeometryTypeImpl(property.getName(), oldGeometryDescriptor.getType().getBinding(), oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                        GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type, property.getName(), 0, 1, true, null);
                        GmlObjectIdImpl identifier = new GmlObjectIdImpl(feature.getID());
                        GeometryAttributeImpl geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                        feature.setDefaultGeometryProperty((GeometryAttribute)geo);
                        feature.setDefaultGeometry((Object)g);
                    }
                    catch (ClassCastException e) {}
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return fc;
    }

    private Configuration resolveConfiguration(QName schematypeTuple) {
        GMLConfiguration configuration = null;
        if (schematypeTuple != null) {
            String schemaLocation = schematypeTuple.getLocalPart();
            if (schemaLocation.startsWith("http://schemas.opengis.net/gml/3.2")) {
                configuration = new GMLConfiguration();
            } else if (schemaLocation != null && schematypeTuple.getNamespaceURI() != null) {
                SchemaRepository.registerSchemaLocation((String)schematypeTuple.getNamespaceURI(), (String)schemaLocation);
                configuration = new ApplicationSchemaConfiguration(schematypeTuple.getNamespaceURI(), schemaLocation);
            } else {
                configuration = new GMLConfiguration();
            }
        } else {
            configuration = new GMLConfiguration();
        }
        return configuration;
    }

    private QName determineFeatureTypeSchema(File file) {
        try {
            GML2Handler handler = new GML2Handler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse((InputStream)new FileInputStream(file), (DefaultHandler)handler);
            String schemaUrl = handler.getSchemaUrl();
            if (schemaUrl == null) {
                return null;
            }
            String namespaceURI = handler.getNameSpaceURI();
            return new QName(namespaceURI, schemaUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static GML32BasicParser getInstanceForConfiguration(Configuration config) {
        GML32BasicParser parser = new GML32BasicParser();
        parser.setConfiguration(config);
        return parser;
    }
}

