/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML2Handler;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GML2BasicParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(GML2BasicParser.class);

    public GML2BasicParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".gml2");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GTVectorDataBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    public GTVectorDataBinding parseXML(File file) {
        SimpleFeatureCollection fc = this.parseSimpleFeatureCollection(file);
        GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection<?, ?>)fc);
        return data;
    }

    public SimpleFeatureCollection parseSimpleFeatureCollection(File file) {
        QName schematypeTuple = this.determineFeatureTypeSchema(file);
        GMLConfiguration configuration = null;
        boolean shouldSetParserStrict = true;
        String schemaLocation = schematypeTuple.getLocalPart();
        if (schemaLocation != null && schematypeTuple.getNamespaceURI() != null) {
            SchemaRepository.registerSchemaLocation((String)schematypeTuple.getNamespaceURI(), (String)schemaLocation);
            configuration = new ApplicationSchemaConfiguration(schematypeTuple.getNamespaceURI(), schemaLocation);
        } else {
            configuration = new GMLConfiguration();
            shouldSetParserStrict = false;
        }
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
        try {
            Object parsedData = null;
            try {
                parser.setStrict(shouldSetParserStrict);
                parsedData = parser.parse((InputStream)new FileInputStream(file));
            }
            catch (SAXException e5) {
                configuration = new GMLConfiguration();
                parser = new Parser((Configuration)configuration);
                parser.setStrict(false);
                parsedData = parser.parse((InputStream)new FileInputStream(file));
            }
            if (parsedData instanceof SimpleFeatureCollection) {
                fc = (SimpleFeatureCollection)parsedData;
            } else {
                ArrayList possibleSimpleFeatureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                if (possibleSimpleFeatureList != null) {
                    ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
                    SimpleFeatureType sft = null;
                    for (Object possibleSimpleFeature : possibleSimpleFeatureList) {
                        if (!(possibleSimpleFeature instanceof SimpleFeature)) continue;
                        SimpleFeature sf = (SimpleFeature)possibleSimpleFeature;
                        if (sft == null) {
                            sft = sf.getType();
                        }
                        simpleFeatureList.add(sf);
                    }
                    fc = new ListFeatureCollection(sft, simpleFeatureList);
                } else {
                    fc = (SimpleFeatureCollection)((HashMap)parsedData).get("FeatureCollection");
                }
            }
            SimpleFeatureIterator featureIterator = fc.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                if (feature.getDefaultGeometry() != null) continue;
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    try {
                        Geometry g = (Geometry)property.getValue();
                        if (g == null) continue;
                        GeometryAttribute oldGeometryDescriptor = feature.getDefaultGeometryProperty();
                        GeometryTypeImpl type = new GeometryTypeImpl(property.getName(), oldGeometryDescriptor.getType().getBinding(), oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                        GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type, property.getName(), 0, 1, true, null);
                        GmlObjectIdImpl identifier = new GmlObjectIdImpl(feature.getID());
                        GeometryAttributeImpl geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                        feature.setDefaultGeometryProperty((GeometryAttribute)geo);
                        feature.setDefaultGeometry((Object)g);
                    }
                    catch (ClassCastException e) {}
                }
            }
            return fc;
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to parse GML2 FeatureCollection.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private QName determineFeatureTypeSchema(File file) {
        try {
            GML2Handler handler = new GML2Handler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse((InputStream)new FileInputStream(file), (DefaultHandler)handler);
            String schemaUrl = handler.getSchemaUrl();
            String namespaceURI = handler.getNameSpaceURI();
            return new QName(namespaceURI, schemaUrl);
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to determining GML2 FeatureType schema.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

