/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.n52.wps.io.data.binding.complex.AsciiGrassDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiGrassParser
extends AbstractParser {
    private static Logger LOGGER = LoggerFactory.getLogger(AsciiGrassParser.class);

    public AsciiGrassParser() {
        this.supportedIDataTypes.add(AsciiGrassDataBinding.class);
    }

    public AsciiGrassDataBinding parse(InputStream input, String mimeType, String schema) {
        GridCoverage2D grid = null;
        try {
            ArcGridReader reader = new ArcGridReader((Object)this.dumpToFile(input));
            grid = (GridCoverage2D)reader.read(null);
            LOGGER.info("getCoordinateReferenceSystem2D(): " + grid.getCoordinateReferenceSystem2D().toString());
            LOGGER.info("getEnvelope():" + grid.getEnvelope2D().toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return new AsciiGrassDataBinding(grid);
    }

    private File dumpToFile(InputStream inputStream) throws FileNotFoundException, IOException {
        int _byte;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        File outputFile = File.createTempFile("temp" + inputStream.hashCode(), "tmp");
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        while ((_byte = bis.read()) != -1) {
            bw.write(_byte);
        }
        bw.close();
        return outputFile;
    }
}

