/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator.mapserver;

import edu.umn.gis.mapscript.classObj;
import edu.umn.gis.mapscript.layerObj;
import edu.umn.gis.mapscript.mapObj;
import edu.umn.gis.mapscript.styleObj;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.datahandler.generator.mapserver.MSColorStyles;
import org.n52.wps.io.datahandler.generator.mapserver.MSLayerBinding;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MSMapfileBinding {
    private static MSMapfileBinding instance = new MSMapfileBinding();
    private static Logger LOGGER = LoggerFactory.getLogger(MSMapfileBinding.class);

    private MSMapfileBinding() {
    }

    public static synchronized MSMapfileBinding getInstance() {
        return instance;
    }

    public synchronized String addFeatureCollectionToMapfile(SimpleFeatureCollection ftColl, String workspacePath, String mapfilePath, String dataRepPath) {
        String shapefilePath = null;
        try {
            shapefilePath = this.saveFeatureCollectionToShapefile(ftColl, workspacePath, dataRepPath);
            LOGGER.debug("Saving FeatureCollection as a Shapefile to the data repository of the mapfile successful.");
        }
        catch (IOException e1) {
            LOGGER.error("Error while saving FeatureCollection as a Shapefile to the data repository of the mapfile.");
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            LOGGER.error("Error while saving FeatureCollection as a Shapefile to the data repository of the mapfile.");
            e1.printStackTrace();
        }
        catch (Exception e) {
            LOGGER.error("Error while saving FeatureCollection as a Shapefile to the data repository of the mapfile.");
            e.printStackTrace();
        }
        String orgMapfilePath = workspacePath + mapfilePath;
        String tmpMapfilePath = workspacePath + System.currentTimeMillis() + ".map";
        try {
            if (!this.copyMapfile(orgMapfilePath, tmpMapfilePath)) {
                LOGGER.error("Error while creating a temporary copy of the mapfile.");
                return null;
            }
            LOGGER.debug("Creating of a temporary copy of the mapfile successful.");
        }
        catch (IOException e) {
            LOGGER.error("Error while creating a temporary copy of the mapfile.");
            e.printStackTrace();
        }
        String layerName = null;
        try {
            layerName = this.addShapefileAsLayerToMapfile(shapefilePath, tmpMapfilePath, workspacePath);
            LOGGER.debug("Adding shapefile as a layer to the mapfile successful.");
        }
        catch (Exception e) {
            LOGGER.error("Error while adding shapefile as a layer to the mapfile.");
            e.printStackTrace();
        }
        try {
            if (this.deleteMapfile(orgMapfilePath) && this.copyMapfile(tmpMapfilePath, orgMapfilePath)) {
                this.deleteMapfile(tmpMapfilePath);
                LOGGER.info("Adding a FeatureCollection as a layer to the mapfile successful.");
                return layerName;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while updating the original mapfile");
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String addShapefileAsLayerToMapfile(String shapefilePath, String tmpMapfilePath, String workspacePath) {
        mapObj mapfileObj = new mapObj(tmpMapfilePath);
        try {
            MSLayerBinding msLayer = null;
            try {
                msLayer = new MSLayerBinding(shapefilePath, workspacePath);
                LOGGER.debug("Initialzing MSLayerBinding object successful.");
            }
            catch (Exception e) {
                LOGGER.error("Error while initializing MSLayerBinding object.");
                e.printStackTrace();
            }
            if (msLayer != null) {
                layerObj layer = new layerObj(mapfileObj);
                layer.setData(msLayer.getDataSourcePath());
                layer.setDump(1);
                layer.setName(msLayer.getMdTitle());
                layer.setProjection(msLayer.getMdCRS());
                layer.setStatus(1);
                layer.setType(msLayer.getGeometryType());
                layer.setMetaData("wms_title", msLayer.getMdTitle());
                layer.setMetaData("wms_timestamp", msLayer.getMdTimestamp());
                classObj layClass = new classObj(layer);
                layClass.setName(msLayer.getMdTitle());
                styleObj layStyle = new styleObj(layClass);
                layStyle.setColor(MSColorStyles.getDefaultColor());
                layStyle.setOutlinecolor(MSColorStyles.getDefaultOutlineColor());
                String wmsSupportedCRS = mapfileObj.getMetaData("wms_srs");
                mapfileObj.setMetaData("wms_srs", this.getMDSupportedCRS(wmsSupportedCRS, msLayer.getMdCRS()));
                mapfileObj.save(tmpMapfilePath);
                LOGGER.debug("Setting layer data successful.");
                String string = msLayer.getMdTitle();
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while adding shapefile to mapfile.");
            e.printStackTrace();
        }
        finally {
            mapfileObj = null;
        }
        return null;
    }

    private String getMDSupportedCRS(String wmsSupportedCrs, String mdCrs) {
        String[] aCrs = wmsSupportedCrs.split(" ");
        for (int i = 0; i < aCrs.length; ++i) {
            if (!aCrs[i].equalsIgnoreCase(mdCrs)) continue;
            return wmsSupportedCrs;
        }
        wmsSupportedCrs = wmsSupportedCrs + " " + mdCrs;
        return wmsSupportedCrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean copyMapfile(String orgMapfilePath, String tmpMapfilePath) throws IOException {
        File orgMapfile = new File(orgMapfilePath);
        File tmpMapfile = new File(tmpMapfilePath);
        FileChannel inCh = new FileInputStream(orgMapfile).getChannel();
        FileChannel outCh = new FileOutputStream(tmpMapfile).getChannel();
        try {
            inCh.transferTo(0L, inCh.size(), outCh);
            LOGGER.debug("Creating of an temporary copy of the mapfile successful.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Error while copying mapfile");
            e.printStackTrace();
        }
        finally {
            if (inCh != null) {
                inCh.close();
            }
            if (outCh != null) {
                outCh.close();
            }
        }
        return false;
    }

    private boolean deleteMapfile(String mapfilePath) {
        File tmpFile = new File(mapfilePath);
        if (tmpFile.exists()) {
            tmpFile.delete();
            return true;
        }
        LOGGER.debug("Mapfile doesn't exist.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFeatureCollectionToShapefile(SimpleFeatureCollection ftColl, String workspacePath, String dataRepository) throws IOException, URISyntaxException, Exception {
        SimpleFeatureType TYPE = (SimpleFeatureType)ftColl.getSchema();
        String shapefilePath = dataRepository.endsWith("/") || dataRepository.endsWith("\\") ? workspacePath + dataRepository + "shape_" + TYPE.getName().getLocalPart().toLowerCase() + "_" + System.currentTimeMillis() + ".shp" : workspacePath + dataRepository + "/shape_" + TYPE.getName().getLocalPart().toLowerCase() + "_" + System.currentTimeMillis() + ".shp";
        File shapefile = new File(shapefilePath);
        URL url = shapefile.toURI().toURL();
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", url);
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        CoordinateReferenceSystem sourceCrs = TYPE.getCoordinateReferenceSystem();
        newDataStore.createSchema(TYPE);
        newDataStore.forceSchemaCRS(sourceCrs);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        SimpleFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        if (featureSource instanceof FeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            featureStore.setTransaction((Transaction)transaction);
            try {
                featureStore.addFeatures((FeatureCollection)ftColl);
                transaction.commit();
                LOGGER.debug("Saving FeatureCollection as shapefile successful.");
            }
            catch (Exception problem) {
                LOGGER.error("Error while saving FeatureCollection as shapefile.");
                problem.printStackTrace();
                transaction.rollback();
            }
            finally {
                transaction.close();
            }
        } else {
            LOGGER.error(typeName + " does not support read/write access");
            return null;
        }
        return url.getPath();
    }
}

