/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator.mapserver;

import edu.umn.gis.mapscript.MS_LAYER_TYPE;
import edu.umn.gis.mapscript.rectObj;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSLayerBinding {
    private String mdSrs;
    private String mdTitle;
    private String mdTimestamp;
    private String dataSourcePath;
    private FeatureSource<?, ?> ftSource;
    private MS_LAYER_TYPE geometryType;
    private rectObj bbox;
    private CoordinateReferenceSystem crs;
    private static Logger LOGGER = LoggerFactory.getLogger(MSLayerBinding.class);

    public MSLayerBinding(String shapePath, String workspace) throws Exception {
        if (this.parseDataSourcePath(shapePath, workspace)) {
            LOGGER.debug("Parsing of the relativ data source path successful.");
            if (this.openShapefile(shapePath)) {
                LOGGER.debug("Opening and parsing of the shapefile successful.");
            } else {
                LOGGER.error("Error while opening and parsing the shapefile.");
            }
        } else {
            LOGGER.error("Shapefile doesn't lie in the folder hierarchy of the mapfile workspace.");
            throw new Exception("Error while opening shapefile: " + shapePath);
        }
        if (!this.parseGeometryDescription()) {
            LOGGER.error("Error while parsing Geometry type.");
            throw new Exception("Error while parsing Geometry type.");
        }
        LOGGER.debug("Parsing Geometry sucessful.");
        ReferencedEnvelope envelope = null;
        try {
            envelope = this.ftSource.getBounds();
            this.crs = envelope.getCoordinateReferenceSystem();
        }
        catch (IOException e) {
            LOGGER.error("Error while parsing the CoordinateReferenceSystem from the shapefile.");
            e.printStackTrace();
        }
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)this.crs, (boolean)true);
            if (code.equalsIgnoreCase("CRS:84")) {
                this.mdSrs = "EPSG:4326";
                LOGGER.debug("Parsing CoordinateReferenceSystem successful.");
            } else {
                this.mdSrs = code;
                LOGGER.debug("Parsing CoordinateReferenceSystem successful.");
            }
        }
        catch (FactoryException e) {
            LOGGER.error("Could not parse the CoorinateReferenceSystem");
            e.printStackTrace();
        }
        this.bbox = new rectObj(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), 0);
        this.mdTitle = this.ftSource.getName().getLocalPart();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd,HH:mm:ss");
        this.mdTimestamp = dateFormat.format(new Date());
        LOGGER.debug("Creating timestamp object sucessful: " + this.mdTimestamp);
    }

    private boolean parseDataSourcePath(String shapePath, String workspace) {
        if (shapePath.contains(workspace)) {
            int tmp = shapePath.length() - (shapePath.length() - workspace.length() - 1);
            this.dataSourcePath = shapePath.substring(tmp, shapePath.length());
            LOGGER.debug("Shapefile lies in the folder hierarchy of the mapfile workspace.");
            return true;
        }
        LOGGER.warn("Shapefile doesn't lies in the folder hierarchy of the mapfile workspace.");
        return false;
    }

    private boolean openShapefile(String shapePath) {
        this.ftSource = null;
        try {
            FileDataStore store = FileDataStoreFinder.getDataStore((File)new File(shapePath));
            this.ftSource = store.getFeatureSource();
        }
        catch (IOException e) {
            LOGGER.error("Error while opening the shapefile.");
            e.printStackTrace();
        }
        if (this.ftSource == null) {
            LOGGER.debug("Could not open shapefile: " + shapePath);
            return false;
        }
        if (this.ftSource != null) {
            LOGGER.debug("Open shapefile as FeatureSource successful.");
            return true;
        }
        return false;
    }

    private boolean parseGeometryDescription() {
        GeometryDescriptor geomDescription = this.ftSource.getSchema().getGeometryDescriptor();
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("POINT")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_POINT;
            return true;
        }
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("MULTIPOINT")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_POINT;
            return true;
        }
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("LINE")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_LINE;
            return true;
        }
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("MULTILINESTRING")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_LINE;
            return true;
        }
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("POLYGON")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_POLYGON;
            return true;
        }
        if (geomDescription.getType().getName().toString().equalsIgnoreCase("MULTIPOLYGON")) {
            this.geometryType = MS_LAYER_TYPE.MS_LAYER_POLYGON;
            return true;
        }
        return false;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public String getMdCRS() {
        return this.mdSrs;
    }

    public String getMdTitle() {
        return this.mdTitle;
    }

    public String getMdTimestamp() {
        return this.mdTimestamp;
    }

    public MS_LAYER_TYPE getGeometryType() {
        return this.geometryType;
    }

    public String getDataSourcePath() {
        return this.dataSourcePath;
    }

    public rectObj getBBox() {
        return this.bbox;
    }

    public String getMdBBox() {
        return this.bbox.getMinx() + " " + this.bbox.getMiny() + " " + this.bbox.getMaxx() + " " + this.bbox.getMaxy();
    }
}

