/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.HttpException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.n52.wps.io.datahandler.generator.mapserver.MSMapfileBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapserverWMSGenerator
extends AbstractGenerator {
    private String mapfile;
    private String workspace;
    private String shapefileRepository;
    private String wmsUrl;
    private static Logger LOGGER = LoggerFactory.getLogger(MapserverWMSGenerator.class);

    public MapserverWMSGenerator() {
        PropertyDocument.Property[] properties;
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        for (PropertyDocument.Property property : properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(((Object)((Object)this)).getClass().getName())) {
            if (property.getName().equalsIgnoreCase("Mapserver_workspace")) {
                this.workspace = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Mapserver_mapfile")) {
                this.mapfile = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Mapserver_dataRepository")) {
                this.shapefileRepository = property.getStringValue();
            }
            if (!property.getName().equalsIgnoreCase("Mapserver_wmsUrl")) continue;
            this.wmsUrl = property.getStringValue();
        }
        for (String supportedFormat : this.supportedFormats) {
            if (!supportedFormat.equals("text/xml")) continue;
            this.supportedFormats.remove(supportedFormat);
        }
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Document doc = this.storeLayer(data);
            String xmlString = XMLUtil.nodeToString((Node)doc);
            stream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        }
        catch (TransformerException ex) {
            LOGGER.error("Error generating MapServer WMS output. Reason: " + ex);
            throw new RuntimeException("Error generating MapServer WMS output. Reason: " + ex);
        }
        catch (IOException e) {
            LOGGER.error("Error generating MapServer WMS output. Reason: " + e);
            throw new RuntimeException("Error generating MapServer WMS output. Reason: " + e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error generating MapServer WMS output. Reason: " + e);
            throw new RuntimeException("Error generating MapServer WMS output. Reason: " + e);
        }
        return stream;
    }

    private Document storeLayer(IData coll) throws HttpException, IOException, ParserConfigurationException {
        try {
            LOGGER.info("Mapscript is running correctly");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Mapscript isn't running correctly");
            return null;
        }
        String wmsLayerName = "";
        if (coll instanceof GTVectorDataBinding) {
            GTVectorDataBinding gtData = (GTVectorDataBinding)coll;
            SimpleFeatureCollection ftColl = (SimpleFeatureCollection)gtData.getPayload();
            wmsLayerName = MSMapfileBinding.getInstance().addFeatureCollectionToMapfile(ftColl, this.workspace, this.mapfile, this.shapefileRepository);
            LOGGER.info("Layer was added to the mapfile");
            System.gc();
        }
        String capabilitiesLink = this.wmsUrl + "?Service=WMS&Request=GetCapabilities";
        Document doc = this.createXML(wmsLayerName, capabilitiesLink);
        LOGGER.info("Capabilities document was generated.");
        return doc;
    }

    private Document createXML(String layerName, String getCapabilitiesLink) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("OWSResponse");
        root.setAttribute("type", "WMS");
        Element resourceIDElement = doc.createElement("ResourceID");
        resourceIDElement.appendChild(doc.createTextNode(layerName));
        root.appendChild(resourceIDElement);
        Element getCapabilitiesLinkElement = doc.createElement("GetCapabilitiesLink");
        getCapabilitiesLinkElement.appendChild(doc.createTextNode(getCapabilitiesLink));
        root.appendChild(getCapabilitiesLinkElement);
        doc.appendChild(root);
        return doc;
    }
}

