/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geotools.feature.FeatureCollection;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(KMLGenerator.class);

    public KMLGenerator() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        File tempFile = null;
        FileInputStream stream = null;
        try {
            tempFile = File.createTempFile("kml", "xml");
            this.finalizeFiles.add(tempFile);
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            this.writeToStream(data, outputStream);
            outputStream.flush();
            outputStream.close();
            stream = new FileInputStream(tempFile);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            throw new IOException("Unable to generate KML");
        }
        return stream;
    }

    private void writeToStream(IData coll, OutputStream os) {
        FeatureCollection<?, ?> fc = ((GTVectorDataBinding)coll).getPayload();
        KMLConfiguration configuration = new KMLConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        try {
            encoder.encode(fc, KML.kml, os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

