/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.n52.wps.io.data.GenericFileDataWithGT;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.complex.GenericFileDataWithGTBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONGeometryGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(JSONGeometryGenerator.class);
    boolean isShapefile = false;
    boolean multiGeometriesToArray = false;

    public JSONGeometryGenerator() {
        this.supportedIDataTypes.add(GenericFileDataWithGTBinding.class);
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        SimpleFeature f;
        LOGGER.info("Starting to generate json geometry out of the process result");
        GTVectorDataBinding gvdb = null;
        if (data instanceof GenericFileDataWithGTBinding) {
            LOGGER.debug("The data passed from the algorithm to the generator is GenericFileDataBinding");
            try {
                gvdb = ((GenericFileDataWithGT)data.getPayload()).getAsGTVectorDataBinding();
                this.isShapefile = true;
            }
            catch (Exception e) {
                throw new IOException("The data passed from the algorithm to the generator is a file, but no shapefile");
            }
        } else if (data instanceof GTVectorDataBinding) {
            LOGGER.debug("The data passed from the algorithm to the generator is GTVectorDataBinding");
            gvdb = (GTVectorDataBinding)data;
            this.isShapefile = false;
        } else {
            throw new IOException("The data passed from the algorithm to the generator has to be a file (shapefile)!");
        }
        FeatureCollection<?, ?> fc = gvdb.getPayload();
        if (fc == null || fc.size() == 0) {
            throw new IOException("No feature was passed to the generator!");
        }
        FeatureIterator fi = fc.features();
        String jsonString = "";
        if (fc.size() == 1) {
            f = (SimpleFeature)fi.next();
            Geometry geom = this.getGeometry(f);
            jsonString = this.transformOneFeature(geom);
        } else {
            jsonString = "[";
            while (fi.hasNext()) {
                f = (SimpleFeature)fi.next();
                Geometry geom = this.getGeometry(f);
                String oneFeatureString = this.transformOneFeature(geom);
                jsonString = jsonString.concat(oneFeatureString + ", ");
            }
            jsonString = jsonString.concat("]");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(jsonString.getBytes());
        return is;
    }

    private Geometry getGeometry(SimpleFeature simpleFeature) throws IOException {
        Geometry geom = null;
        geom = simpleFeature.getDefaultGeometry() == null && simpleFeature.getAttributeCount() > 0 && simpleFeature.getAttribute(0) instanceof Geometry ? (Geometry)simpleFeature.getAttribute(0) : (Geometry)simpleFeature.getDefaultGeometry();
        if (geom == null || !(geom instanceof Geometry)) {
            LOGGER.error("Geometry could not be extracted");
            throw new IOException("Geometry could not be extracted!");
        }
        LOGGER.debug("Geometry extracted");
        return geom;
    }

    private String transformOneFeature(Geometry geom) throws IOException {
        String jsonString = "";
        if (geom instanceof Point) {
            jsonString = this.transformPointToJsonPoint((Point)geom);
        } else if (geom instanceof LineString) {
            jsonString = this.transformLineStringToJsonLineString((LineString)geom);
        } else if (geom instanceof Polygon) {
            jsonString = this.transformPolygonToJsonPolygon((Polygon)geom);
        } else if (geom instanceof MultiPoint) {
            MultiPoint multipoint = (MultiPoint)geom;
            if (multipoint.getNumGeometries() == 1) {
                Point point = (Point)multipoint.getGeometryN(0);
                jsonString = this.transformPointToJsonPoint(point);
            } else {
                jsonString = this.transformMultiPointToJsonMultiPoint(multipoint);
            }
        } else if (geom instanceof MultiLineString) {
            MultiLineString multiline = (MultiLineString)geom;
            if (multiline.getNumGeometries() == 1) {
                LineString line = (LineString)multiline.getGeometryN(0);
                jsonString = this.transformLineStringToJsonLineString(line);
            } else {
                jsonString = this.multiGeometriesToArray ? this.transformMultiLineStringToJsonLineStringArray(multiline) : this.transformMultiLineStringToJsonLineString(multiline);
            }
        } else if (geom instanceof MultiPolygon) {
            MultiPolygon multipoly = (MultiPolygon)geom;
            if (multipoly.getNumGeometries() == 1) {
                Polygon poly = (Polygon)multipoly.getGeometryN(0);
                jsonString = this.transformPolygonToJsonPolygon(poly);
            } else {
                jsonString = this.multiGeometriesToArray ? this.transformMultiPolygonToJsonPolygonArray(multipoly) : this.transformMultiPolygonToJsonPolygon(multipoly);
            }
        } else {
            LOGGER.error("Feature has no recognized geometry type");
        }
        return jsonString;
    }

    private String transformPointToJsonPoint(Point p) {
        String wkid;
        double northsouth;
        double eastwest;
        LOGGER.info("Transforming point to JSON point.");
        Coordinate coordinatePair = p.getCoordinate();
        double x = coordinatePair.x;
        double y = coordinatePair.y;
        LOGGER.debug("Point's coordinates: " + x + ", " + y);
        if (this.isShapefile) {
            eastwest = x;
            northsouth = y;
        } else {
            northsouth = x;
            eastwest = y;
        }
        try {
            wkid = this.crsToJsonSpatialReference((Geometry)p);
        }
        catch (IOException e) {
            wkid = "\"spatialReference\":{\"wkid\":0000}";
        }
        LOGGER.info("Point's CRS: " + wkid);
        String jsonString = "{\"x\": " + eastwest + ", \"y\": " + northsouth + ", " + wkid + "}";
        LOGGER.info("Finished JSON point: " + jsonString);
        return jsonString;
    }

    private String transformMultiPointToJsonMultiPoint(MultiPoint multipoint) {
        String wkid;
        LOGGER.info("Transforming multipoint to json multipoint");
        try {
            wkid = this.crsToJsonSpatialReference((Geometry)multipoint);
        }
        catch (IOException e) {
            wkid = "\"spatialReference\":{\"wkid\":0000}";
        }
        LOGGER.debug("Point's CRS: " + wkid);
        String jsonString = "{\"points\":[";
        boolean firstElement = true;
        for (int i = 0; i < multipoint.getNumGeometries(); ++i) {
            double northsouth;
            double eastwest;
            Point point = (Point)multipoint.getGeometryN(i);
            String onePointString = "[";
            Coordinate coordinatePair = point.getCoordinate();
            double x = coordinatePair.x;
            double y = coordinatePair.y;
            LOGGER.info("Point's coordinates: " + x + ", " + y);
            if (this.isShapefile) {
                eastwest = x;
                northsouth = y;
            } else {
                northsouth = x;
                eastwest = y;
            }
            onePointString = onePointString.concat(eastwest + "," + northsouth + "]");
            if (firstElement) {
                jsonString = jsonString.concat(onePointString);
                firstElement = false;
                continue;
            }
            jsonString = jsonString.concat("," + onePointString);
        }
        jsonString = jsonString.concat("], " + wkid + "}");
        return jsonString;
    }

    private String transformLineStringToJsonLineString(LineString linestring) {
        LOGGER.info("Transforming linestring to JSON linestring");
        String aPath = this.linestringToJsonPath(linestring);
        String aJsonLine = this.assembleLine(aPath, (Geometry)linestring);
        return aJsonLine;
    }

    private String transformMultiLineStringToJsonLineString(MultiLineString multilinestring) {
        LOGGER.info("Transforming multilinestring to JSON linestring with several paths in it.");
        String allPaths = "";
        boolean firstElement = true;
        for (int i = 0; i < multilinestring.getNumGeometries(); ++i) {
            LineString linestring = (LineString)multilinestring.getGeometryN(i);
            String aPath = this.linestringToJsonPath(linestring);
            if (firstElement) {
                allPaths = allPaths.concat(aPath);
                firstElement = false;
                continue;
            }
            allPaths = allPaths.concat(", " + aPath);
        }
        String jsonString = this.assembleLine(allPaths, (Geometry)multilinestring);
        return jsonString;
    }

    private String transformMultiLineStringToJsonLineStringArray(MultiLineString multilinestring) {
        LOGGER.info("Transforming multilinestring to JSON linestring array");
        String lineArray = "[";
        boolean firstElement = true;
        for (int i = 0; i < multilinestring.getNumGeometries(); ++i) {
            LineString linestring = (LineString)multilinestring.getGeometryN(i);
            String aLine = this.transformLineStringToJsonLineString(linestring);
            if (firstElement) {
                lineArray = lineArray.concat(aLine);
                firstElement = false;
                continue;
            }
            lineArray = lineArray.concat(", " + aLine);
        }
        return lineArray;
    }

    private String assembleLine(String aPathOrSeveralPaths, Geometry geometry) {
        String spatialReference;
        try {
            spatialReference = this.crsToJsonSpatialReference(geometry);
        }
        catch (IOException e) {
            spatialReference = "\"spatialReference\":{\"wkid\":0000}";
        }
        String jsonString = "{\"paths\":[" + aPathOrSeveralPaths + "]," + spatialReference + "}";
        return jsonString;
    }

    private String linestringToJsonPath(LineString ls) {
        Coordinate[] coordinateArray = ls.getCoordinates();
        String aPath = "[";
        boolean firstElement = true;
        for (Coordinate coordinatePair : coordinateArray) {
            double eastwest = 0.0;
            double northsouth = 0.0;
            if (this.isShapefile) {
                eastwest = coordinatePair.x;
                northsouth = coordinatePair.y;
            } else {
                eastwest = coordinatePair.y;
                northsouth = coordinatePair.x;
            }
            String coordinatePairString = "";
            if (firstElement) {
                coordinatePairString = "[" + eastwest + "," + northsouth + "]";
                firstElement = false;
            } else {
                coordinatePairString = ", [" + eastwest + "," + northsouth + "]";
            }
            aPath = aPath.concat(coordinatePairString);
        }
        aPath = aPath.concat("]");
        return aPath;
    }

    private String transformPolygonToJsonPolygon(Polygon polygon) {
        LOGGER.info("Transforming simple polygon to JSON polygon");
        String aRing = this.getPathFromPolygon(polygon);
        String jsonString = this.assemblePolygon(aRing, (Geometry)polygon);
        return jsonString;
    }

    private String transformMultiPolygonToJsonPolygon(MultiPolygon multipolygon) {
        LOGGER.info("Transforming multipolygon to JSON polygon with several rings in it.");
        String allRings = "";
        boolean firstElement = true;
        for (int i = 0; i < multipolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multipolygon.getGeometryN(i);
            String aRing = this.getPathFromPolygon(polygon);
            if (firstElement) {
                allRings = allRings.concat(aRing);
                firstElement = false;
                continue;
            }
            allRings = allRings.concat(", " + aRing);
        }
        String jsonString = this.assemblePolygon(allRings, (Geometry)multipolygon);
        return jsonString;
    }

    private String transformMultiPolygonToJsonPolygonArray(MultiPolygon multipolygon) {
        LOGGER.info("Transforming multipolygon to JSON polygon array");
        String polygonArray = "[";
        boolean firstElement = true;
        for (int i = 0; i < multipolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multipolygon.getGeometryN(i);
            String aPolygon = this.transformPolygonToJsonPolygon(polygon);
            if (firstElement) {
                polygonArray = polygonArray.concat(aPolygon);
                firstElement = false;
                continue;
            }
            polygonArray = polygonArray.concat(", " + aPolygon);
        }
        return polygonArray;
    }

    private String getPathFromPolygon(Polygon polygon) {
        int holes = polygon.getNumInteriorRing();
        if (holes < 0) {
            LOGGER.info("The polygon that is being transformed to an json geometry has holes. Holes are not accepted. Only the outer ring will be transformed.");
        }
        LineString outer = polygon.getExteriorRing();
        String aRing = this.linestringToJsonPath(outer);
        return aRing;
    }

    private String assemblePolygon(String aRingOrSeveralRings, Geometry geometry) {
        String spatialReference;
        try {
            spatialReference = this.crsToJsonSpatialReference(geometry);
        }
        catch (IOException e) {
            spatialReference = "\"spatialReference\":{\"wkid\":0000}";
        }
        String jsonString = "{\"rings\": [" + aRingOrSeveralRings + "], " + spatialReference + "}";
        return jsonString;
    }

    private String crsToJsonSpatialReference(Geometry geom) throws IOException {
        String wkid = "";
        int refsys = geom.getSRID();
        if (refsys == 0) {
            throw new IOException("The GML geometry that is being transformed to a json polyline does not have a spatial reference (srid)");
        }
        Integer i = new Integer(refsys);
        wkid = i.toString();
        wkid = "\"spatialReference\":{\"wkid\":" + wkid + "}";
        return wkid;
    }
}

