/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.HttpException;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.GenericFileDataWithGT;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.n52.wps.io.datahandler.generator.GeoServerUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoserverWFSGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(GeoserverWFSGenerator.class);
    private String username;
    private String password;
    private String host;
    private String port;

    public GeoserverWFSGenerator() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        for (PropertyDocument.Property property : this.properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(((Object)((Object)this)).getClass().getName())) {
            if (property.getName().equalsIgnoreCase("Geoserver_username")) {
                this.username = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_password")) {
                this.password = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_host")) {
                this.host = property.getStringValue();
            }
            if (!property.getName().equalsIgnoreCase("Geoserver_port")) continue;
            this.port = property.getStringValue();
        }
        if (this.port == null) {
            this.port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        }
        for (String supportedFormat : this.supportedFormats) {
            if (!supportedFormat.equals("text/xml")) continue;
            this.supportedFormats.remove(supportedFormat);
        }
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Document doc = this.storeLayer(data);
            String xmlString = XMLUtil.nodeToString((Node)doc);
            stream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        }
        catch (TransformerException e) {
            LOGGER.error("Error generating WFS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WFS output. Reason: " + e);
        }
        catch (IOException e) {
            LOGGER.error("Error generating WFS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WFS output. Reason: " + e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error generating WFS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WFS output. Reason: " + e);
        }
        return stream;
    }

    private Document storeLayer(IData coll) throws HttpException, IOException, ParserConfigurationException {
        GTVectorDataBinding gtData = (GTVectorDataBinding)coll;
        File file = null;
        try {
            GenericFileDataWithGT fileData = new GenericFileDataWithGT(gtData.getPayload());
            file = fileData.getBaseFile(true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Error generating shp file for storage in WFS. Reason: " + e1);
        }
        String path = file.getAbsolutePath();
        String baseName = path.substring(0, path.length() - ".shp".length());
        File shx = new File(baseName + ".shx");
        File dbf = new File(baseName + ".dbf");
        File prj = new File(baseName + ".prj");
        File zipped = IOUtils.zip((File[])new File[]{file, shx, dbf, prj});
        String layerName = zipped.getName();
        layerName = layerName + "_" + UUID.randomUUID();
        GeoServerUploader geoserverUploader = new GeoServerUploader(this.username, this.password, this.host, this.port);
        String result = geoserverUploader.createWorkspace();
        LOGGER.debug(result);
        result = geoserverUploader.uploadShp(zipped, layerName);
        LOGGER.debug(result);
        String capabilitiesLink = "http://" + this.host + ":" + this.port + "/geoserver/wfs?Service=WFS&Request=GetCapabilities&Version=1.1.0";
        zipped.delete();
        file.delete();
        shx.delete();
        dbf.delete();
        prj.delete();
        Document doc = this.createXML("N52:" + file.getName().subSequence(0, file.getName().length() - 4), capabilitiesLink);
        return doc;
    }

    private Document createXML(String layerName, String getCapabilitiesLink) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("OWSResponse");
        root.setAttribute("type", "WFS");
        Element resourceIDElement = doc.createElement("ResourceID");
        resourceIDElement.appendChild(doc.createTextNode(layerName));
        root.appendChild(resourceIDElement);
        Element getCapabilitiesLinkElement = doc.createElement("GetCapabilitiesLink");
        getCapabilitiesLinkElement.appendChild(doc.createTextNode(getCapabilitiesLink));
        root.appendChild(getCapabilitiesLinkElement);
        doc.appendChild(root);
        return doc;
    }
}

