/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.HttpException;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.io.data.GenericFileDataWithGT;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.data.binding.complex.GeotiffBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.n52.wps.io.datahandler.generator.GeoServerUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeoserverWCSGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(GeoserverWCSGenerator.class);
    private String username;
    private String password;
    private String host;
    private String port;

    public GeoserverWCSGenerator() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
        this.supportedIDataTypes.add(GeotiffBinding.class);
        for (PropertyDocument.Property property : this.properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(((Object)((Object)this)).getClass().getName())) {
            if (property.getName().equalsIgnoreCase("Geoserver_username")) {
                this.username = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_password")) {
                this.password = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_host")) {
                this.host = property.getStringValue();
            }
            if (!property.getName().equalsIgnoreCase("Geoserver_port")) continue;
            this.port = property.getStringValue();
        }
        if (this.port == null) {
            this.port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        }
        for (String supportedFormat : this.supportedFormats) {
            if (!supportedFormat.equals("text/xml")) continue;
            this.supportedFormats.remove(supportedFormat);
        }
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Document doc = this.storeLayer(data);
            String xmlString = XMLUtil.nodeToString((Node)doc);
            stream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        }
        catch (TransformerException e) {
            LOGGER.error("Error generating WCS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WCS output. Reason: " + e);
        }
        catch (IOException e) {
            LOGGER.error("Error generating WCS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WCS output. Reason: " + e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error generating WCS output. Reason: ", (Throwable)e);
            throw new RuntimeException("Error generating WCS output. Reason: " + e);
        }
        return stream;
    }

    private Document storeLayer(IData coll) throws HttpException, IOException, ParserConfigurationException {
        File file = null;
        String storeName = "";
        if (coll instanceof GTRasterDataBinding) {
            GTRasterDataBinding gtData = (GTRasterDataBinding)coll;
            GenericFileDataWithGT fileData = new GenericFileDataWithGT(gtData.getPayload(), null);
            file = fileData.getBaseFile(true);
        }
        if (coll instanceof GeotiffBinding) {
            GeotiffBinding data = (GeotiffBinding)coll;
            file = data.getPayload();
        }
        storeName = file.getName();
        storeName = storeName + "_" + UUID.randomUUID();
        GeoServerUploader geoserverUploader = new GeoServerUploader(this.username, this.password, this.host, this.port);
        String result = geoserverUploader.createWorkspace();
        LOGGER.debug(result);
        if (coll instanceof GTRasterDataBinding) {
            result = geoserverUploader.uploadGeotiff(file, storeName);
        }
        LOGGER.debug(result);
        String capabilitiesLink = "http://" + this.host + ":" + this.port + "/geoserver/wcs?Service=WCS&Request=GetCapabilities&Version=1.1.1";
        Document doc = this.createXML(storeName, capabilitiesLink);
        return doc;
    }

    private Document createXML(String layerName, String getCapabilitiesLink) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("OWSResponse");
        root.setAttribute("type", "WMS");
        Element resourceIDElement = doc.createElement("ResourceID");
        resourceIDElement.appendChild(doc.createTextNode(layerName));
        root.appendChild(resourceIDElement);
        Element getCapabilitiesLinkElement = doc.createElement("GetCapabilitiesLink");
        getCapabilitiesLinkElement.appendChild(doc.createTextNode(getCapabilitiesLink));
        root.appendChild(getCapabilitiesLinkElement);
        doc.appendChild(root);
        return doc;
    }
}

