/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class GeoServerUploader {
    private String username;
    private String password;
    private String host;
    private String port;

    public GeoServerUploader(String username, String password, String host, String port) {
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public String uploadGeotiff(File file, String storeName) throws HttpException, IOException {
        String target = "http://" + this.host + ":" + this.port + "/geoserver/rest/workspaces/N52/coveragestores/" + storeName + "/external.geotiff?configure=first&coverageName=" + storeName;
        String request = file.getAbsolutePath().startsWith("/") ? "file:" + file.getAbsolutePath() : "file:/" + file.getAbsolutePath();
        String result = this.sendRasterRequest(target, request, "PUT", this.username, this.password);
        return result;
    }

    public String uploadShp(File file, String storeName) throws HttpException, IOException {
        String target = "http://" + this.host + ":" + this.port + "/geoserver/rest/workspaces/N52/datastores/" + storeName + "/file.shp";
        BufferedInputStream request = new BufferedInputStream(new FileInputStream(file));
        String result = this.sendShpRequest(target, request, "PUT", this.username, this.password);
        return result;
    }

    public String createWorkspace() throws HttpException, IOException {
        String target = "http://" + this.host + ":" + this.port + "/geoserver/rest/workspaces";
        String request = "<workspace><name>N52</name></workspace>";
        String result = this.sendRasterRequest(target, request, "POST", this.username, this.password);
        return result;
    }

    private String sendRasterRequest(String target, String request, String method, String username, String password) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        PostMethod requestMethod = null;
        if (method.equalsIgnoreCase("POST")) {
            requestMethod = new PostMethod(target);
            requestMethod.setRequestHeader("Content-type", "application/xml");
        }
        if (method.equalsIgnoreCase("PUT")) {
            requestMethod = new PutMethod(target);
            requestMethod.setRequestHeader("Content-type", "text/plain");
        }
        requestMethod.setRequestBody(request);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        client.getState().setCredentials(null, null, (Credentials)creds);
        int statusCode = client.executeMethod((HttpMethod)requestMethod);
        if (statusCode != 200 && statusCode != 201) {
            System.err.println("Method failed: " + requestMethod.getStatusLine());
        }
        byte[] responseBody = requestMethod.getResponseBody();
        return new String(responseBody);
    }

    private String sendShpRequest(String target, InputStream request, String method, String username, String password) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        PostMethod requestMethod = null;
        if (method.equalsIgnoreCase("POST")) {
            requestMethod = new PostMethod(target);
            requestMethod.setRequestHeader("Content-type", "text/xml");
        }
        if (method.equalsIgnoreCase("PUT")) {
            requestMethod = new PutMethod(target);
            requestMethod.setRequestHeader("Content-type", "application/zip");
        }
        requestMethod.setRequestBody(request);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        client.getState().setCredentials(null, null, (Credentials)creds);
        int statusCode = client.executeMethod((HttpMethod)requestMethod);
        if (statusCode != 200 && statusCode != 201) {
            System.err.println("Method failed: " + requestMethod.getStatusLine());
        }
        byte[] responseBody = requestMethod.getResponseBody();
        return new String(responseBody);
    }
}

