/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.complex.JTSGeometryBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;

public class GeoJSONGenerator
extends AbstractGenerator {
    public GeoJSONGenerator() {
        this.supportedIDataTypes.add(JTSGeometryBinding.class);
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        if (data instanceof JTSGeometryBinding) {
            Geometry g = ((JTSGeometryBinding)data).getPayload();
            File tempFile = File.createTempFile("wps", "json");
            this.finalizeFiles.add(tempFile);
            new GeometryJSON().write(g, (Object)tempFile);
            FileInputStream is = new FileInputStream(tempFile);
            return is;
        }
        if (data instanceof GTVectorDataBinding) {
            SimpleFeatureCollection f = (SimpleFeatureCollection)data.getPayload();
            File tempFile = File.createTempFile("wps", "json");
            this.finalizeFiles.add(tempFile);
            new FeatureJSON().writeFeatureCollection((FeatureCollection)f, (Object)tempFile);
            FileInputStream is = new FileInputStream(tempFile);
            return is;
        }
        return null;
    }
}

