/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.n52.wps.io.GTHelper;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class GTBinDirectorySHPGenerator {
    public File writeFeatureCollectionToDirectory(IData data) throws IOException {
        return this.writeFeatureCollectionToDirectory(data, null);
    }

    public File writeFeatureCollectionToDirectory(IData data, File parent) throws IOException {
        GTVectorDataBinding binding = (GTVectorDataBinding)data;
        FeatureCollection<?, ?> originalCollection = binding.getPayload();
        FeatureCollection collection = this.createCorrectFeatureCollection(originalCollection);
        return this.createShapefileDirectory(collection, parent);
    }

    private FeatureCollection createCorrectFeatureCollection(FeatureCollection fc) {
        SimpleFeatureCollection resultFeatureCollection = DefaultFeatureCollections.newCollection();
        SimpleFeatureType featureType = null;
        FeatureIterator iterator = fc.features();
        String uuid = UUID.randomUUID().toString();
        int i = 0;
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            if (i == 0) {
                featureType = GTHelper.createFeatureType(feature.getProperties(), (Geometry)feature.getDefaultGeometry(), uuid, feature.getFeatureType().getCoordinateReferenceSystem());
                QName qname = GTHelper.createGML3SchemaForFeatureType(featureType);
                SchemaRepository.registerSchemaLocation((String)qname.getNamespaceURI(), (String)qname.getLocalPart());
            }
            SimpleFeature resultFeature = GTHelper.createFeature("ID" + i, (Geometry)feature.getDefaultGeometry(), featureType, feature.getProperties());
            resultFeatureCollection.add((Feature)resultFeature);
            ++i;
        }
        return resultFeatureCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createShapefileDirectory(FeatureCollection collection, File parent) throws IOException, IllegalAttributeException {
        if (parent == null) {
            File tempBaseFile = File.createTempFile("resolveDir", ".tmp");
            tempBaseFile.deleteOnExit();
            parent = tempBaseFile.getParentFile();
        }
        if (parent == null || !parent.isDirectory()) {
            throw new IllegalStateException("Could not find temporary file directory.");
        }
        File shpBaseDirectory = new File(parent, UUID.randomUUID().toString());
        if (!shpBaseDirectory.mkdir()) {
            throw new IllegalStateException("Could not create temporary shp directory.");
        }
        File tempSHPfile = File.createTempFile("shp", ".shp", shpBaseDirectory);
        tempSHPfile.deleteOnExit();
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", tempSHPfile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema((SimpleFeatureType)collection.getSchema());
        if (collection.getSchema().getCoordinateReferenceSystem() == null) {
            try {
                newDataStore.forceSchemaCRS(CRS.decode((String)"4326"));
            }
            catch (NoSuchAuthorityCodeException e) {
                e.printStackTrace();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
        } else {
            newDataStore.forceSchemaCRS(collection.getSchema().getCoordinateReferenceSystem());
        }
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        FeatureStore featureStore = (FeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures(collection);
            transaction.commit();
        }
        catch (Exception problem) {
            transaction.rollback();
        }
        finally {
            transaction.close();
        }
        String path = tempSHPfile.getAbsolutePath();
        String baseName = path.substring(0, path.length() - ".shp".length());
        File shx = new File(baseName + ".shx");
        File dbf = new File(baseName + ".dbf");
        File prj = new File(baseName + ".prj");
        tempSHPfile.deleteOnExit();
        shx.deleteOnExit();
        dbf.deleteOnExit();
        prj.deleteOnExit();
        shpBaseDirectory.deleteOnExit();
        return shpBaseDirectory;
    }
}

