/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.n52.wps.io.GTHelper;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GML3BasicGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(GML3BasicGenerator.class);

    public GML3BasicGenerator() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    public void writeToStream(IData coll, OutputStream os) {
        FeatureCollection<?, ?> fc = ((GTVectorDataBinding)coll).getPayload();
        SimpleFeatureCollection correctFeatureCollection = this.createCorrectFeatureCollection(fc);
        FeatureType schema = correctFeatureCollection.getSchema();
        String namespace = null;
        String schemaLocation = null;
        if (schema != null) {
            namespace = schema.getName().getNamespaceURI();
            schemaLocation = SchemaRepository.getSchemaLocation((String)namespace);
        }
        ApplicationSchemaConfiguration configuration = null;
        Encoder encoder = null;
        if (schemaLocation == null || namespace == null) {
            namespace = "http://www.opengis.net/gml";
            schemaLocation = "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd";
            configuration = new GMLConfiguration();
            encoder = new Encoder((Configuration)configuration);
            encoder.setNamespaceAware(true);
            encoder.setSchemaLocation("http://www.opengis.net/gml", "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd");
        } else {
            configuration = new ApplicationSchemaConfiguration(namespace, schemaLocation);
            encoder = new Encoder((Configuration)configuration);
            encoder.setNamespaceAware(true);
            encoder.setSchemaLocation("http://www.opengis.net/gml http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", namespace + " " + schemaLocation);
        }
        fc.features().close();
        QName ns = new QName("http://www.opengis.net/gml", "FeatureCollection", "wfs");
        try {
            encoder.encode((Object)correctFeatureCollection, ns, os);
        }
        catch (IOException e) {
            LOGGER.error("Exception while trying to encode FeatureCollection.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        String uuid = UUID.randomUUID().toString();
        File file = File.createTempFile("gml3" + uuid, ".xml");
        FileOutputStream outputStream = new FileOutputStream(file);
        this.writeToStream(data, outputStream);
        outputStream.flush();
        outputStream.close();
        if (file.length() <= 0L) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        return inputStream;
    }

    private SimpleFeatureCollection createCorrectFeatureCollection(FeatureCollection<?, ?> fc) {
        ArrayList<SimpleFeature> simpleFeatureList = new ArrayList<SimpleFeature>();
        SimpleFeatureType featureType = null;
        FeatureIterator iterator = fc.features();
        String uuid = UUID.randomUUID().toString();
        int i = 0;
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            if (i == 0) {
                featureType = GTHelper.createFeatureType(feature.getProperties(), (Geometry)feature.getDefaultGeometry(), uuid, feature.getFeatureType().getCoordinateReferenceSystem());
                QName qname = GTHelper.createGML3SchemaForFeatureType(featureType);
                SchemaRepository.registerSchemaLocation((String)qname.getNamespaceURI(), (String)qname.getLocalPart());
            }
            SimpleFeature resultFeature = GTHelper.createFeature("ID" + i, (Geometry)feature.getDefaultGeometry(), featureType, feature.getProperties());
            simpleFeatureList.add(resultFeature);
            ++i;
        }
        iterator.close();
        ListFeatureCollection resultFeatureCollection = new ListFeatureCollection(featureType, simpleFeatureList);
        return resultFeatureCollection;
    }
}

