/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiGrassGenerator
extends AbstractGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(AsciiGrassGenerator.class);

    public AsciiGrassGenerator() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
    }

    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        FileInputStream stream = null;
        GridCoverage2D grid = ((GTRasterDataBinding)data).getPayload();
        String fileName = "temp" + UUID.randomUUID();
        File outputFile = File.createTempFile(fileName, ".tmp");
        outputFile.deleteOnExit();
        this.finalizeFiles.add(outputFile);
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)outputFile);
            ParameterValueGroup params = writer.getFormat().getWriteParameters();
            params.parameter("GRASS").setValue(true);
            GeneralParameterValue[] gpv = new GeneralParameterValue[]{params.parameter("GRASS")};
            writer.write((GridCoverage)grid, gpv);
            writer.dispose();
            stream = new FileInputStream(outputFile);
        }
        catch (DataSourceException e) {
            LOGGER.error(e.getMessage());
            throw new IOException("AsciiGRID cannot be read from source");
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            throw new IOException("Illegal configuration of AsciiGRID writer");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            throw new IOException("AsciiGrassGenerator could not create output due to an IO error");
        }
        return stream;
    }
}

