/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.data.binding.complex;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.io.FileUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileBinding
implements IComplexData {
    private static final long serialVersionUID = 1L;
    private static Logger LOGGER = LoggerFactory.getLogger(ShapefileBinding.class);
    protected File shpFile;
    protected String mimeType;

    public ShapefileBinding(File shapeFile) {
        this.shpFile = shapeFile;
        this.mimeType = "application/x-zipped-shp";
    }

    public File getPayload() {
        return this.shpFile;
    }

    public Class getSupportedClass() {
        return File.class;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public File getZippedPayload() {
        String path = this.shpFile.getAbsolutePath();
        String baseName = path.substring(0, path.length() - ".shp".length());
        File shx = new File(baseName + ".shx");
        File dbf = new File(baseName + ".dbf");
        File prj = new File(baseName + ".prj");
        File zipped = null;
        try {
            zipped = IOUtils.zip((File[])new File[]{this.shpFile, shx, dbf, prj});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return zipped;
    }

    public GTVectorDataBinding getPayloadAsGTVectorDataBinding() {
        try {
            ShapefileDataStore store = new ShapefileDataStore(this.shpFile.toURI().toURL());
            SimpleFeatureCollection features = store.getFeatureSource(store.getTypeNames()[0]).getFeatures();
            return new GTVectorDataBinding((FeatureCollection<?, ?>)features);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Something went wrong while creating data store.", (Throwable)e);
            throw new RuntimeException("Something went wrong while creating data store.", e);
        }
        catch (IOException e) {
            LOGGER.error("Something went wrong while converting shapefile to FeatureCollection", (Throwable)e);
            throw new RuntimeException("Something went wrong while converting shapefile to FeatureCollection", e);
        }
    }

    public void dispose() {
        FileUtils.deleteQuietly((File)this.shpFile);
    }
}

