/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.data;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.GenericFileDataConstants;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.GeotiffGenerator;
import org.n52.wps.io.datahandler.parser.GML2BasicParser;
import org.n52.wps.io.datahandler.parser.GML3BasicParser;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.identity.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileDataWithGT {
    private static Logger LOGGER = LoggerFactory.getLogger(GenericFileDataWithGT.class);
    protected final InputStream dataStream;
    protected String fileExtension;
    protected final String mimeType;
    protected File primaryFile;

    public GenericFileDataWithGT(InputStream stream, String mimeType) {
        this.dataStream = stream;
        this.mimeType = mimeType;
        this.fileExtension = (String)GenericFileDataConstants.mimeTypeFileTypeLUT().get(mimeType);
        if (this.fileExtension == null) {
            this.fileExtension = "dat";
        }
    }

    public GenericFileDataWithGT(FeatureCollection<?, ?> featureCollection) throws IOException {
        this(GenericFileDataWithGT.getShpFile(featureCollection), "application/x-zipped-shp");
    }

    public GenericFileDataWithGT(File primaryTempFile, String mimeType) throws IOException {
        this.primaryFile = primaryTempFile;
        this.mimeType = mimeType;
        this.fileExtension = (String)GenericFileDataConstants.mimeTypeFileTypeLUT().get(mimeType);
        FileInputStream is = null;
        if (GenericFileDataConstants.getIncludeFilesByMimeType((String)mimeType) != null) {
            String baseFile = this.primaryFile.getName();
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("."));
            File temp = new File(this.primaryFile.getAbsolutePath());
            File directory = new File(temp.getParent());
            String[] extensions = GenericFileDataConstants.getIncludeFilesByMimeType((String)mimeType);
            File[] allFiles = new File[extensions.length + 1];
            for (int i = 0; i < extensions.length; ++i) {
                allFiles[i] = new File(directory, baseFile + "." + extensions[i]);
            }
            allFiles[extensions.length] = this.primaryFile;
            int numberOfFiles = allFiles.length;
            int numberOfMissing = 0;
            for (int i = 0; i < numberOfFiles; ++i) {
                if (allFiles[i].exists()) continue;
                LOGGER.info("File " + (i + 1) + " of " + numberOfFiles + " missing (" + allFiles[i].getName() + ").");
                ++numberOfMissing;
            }
            if (numberOfFiles - numberOfMissing == 0) {
                String message = "There is no files to generate data from!";
                LOGGER.error(message);
                throw new FileNotFoundException(message);
            }
            if (numberOfMissing > 0) {
                LOGGER.info("Not all files are available, but the available ones are zipped.");
            }
            is = new FileInputStream(IOUtils.zip((File[])allFiles));
        } else {
            is = new FileInputStream(this.primaryFile);
        }
        this.dataStream = is;
    }

    public GenericFileDataWithGT(GridCoverage2D payload, String mimeType) {
        this.dataStream = null;
        this.fileExtension = "tiff";
        this.mimeType = mimeType;
        try {
            GeotiffGenerator generator = new GeotiffGenerator();
            this.primaryFile = File.createTempFile("primary", ".tif");
            FileOutputStream outputStream = new FileOutputStream(this.primaryFile);
            InputStream is = generator.generateStream((IData)new GTRasterDataBinding(payload), mimeType, null);
            org.apache.commons.io.IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            is.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not generate GeoTiff.");
        }
    }

    public static File getShpFile(FeatureCollection<?, ?> collection) throws IOException, IllegalAttributeException {
        Object sf;
        SimpleFeatureType type = null;
        SimpleFeatureBuilder build = null;
        FeatureIterator iterator = collection.features();
        DefaultFeatureCollection modifiedFeatureCollection = null;
        DefaultTransaction transaction = new DefaultTransaction("create");
        FeatureStore store = null;
        String uuid = UUID.randomUUID().toString();
        File shp = File.createTempFile("Shape_" + uuid, ".shp");
        shp.deleteOnExit();
        while (iterator.hasNext()) {
            sf = (SimpleFeature)iterator.next();
            if (type == null) {
                SimpleFeatureType inType = (SimpleFeatureType)collection.getSchema();
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(inType.getName());
                builder.setNamespaceURI(inType.getName().getNamespaceURI());
                if (collection.getSchema().getCoordinateReferenceSystem() == null) {
                    builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                } else {
                    builder.setCRS(collection.getSchema().getCoordinateReferenceSystem());
                }
                builder.setDefaultGeometry(sf.getDefaultGeometryProperty().getName().getLocalPart());
                GeometryAttribute geomProperty = sf.getDefaultGeometryProperty();
                if (geomProperty.getType().getBinding().getSimpleName().equals("Geometry")) {
                    Geometry g = (Geometry)geomProperty.getValue();
                    if (g != null) {
                        GeometryAttributeImpl geo = null;
                        if (g instanceof MultiPolygon) {
                            GeometryAttribute oldGeometryDescriptor = sf.getDefaultGeometryProperty();
                            GeometryTypeImpl type1 = new GeometryTypeImpl(geomProperty.getName(), MultiPolygon.class, oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                            GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type1, geomProperty.getName(), 0, 1, true, null);
                            GmlObjectIdImpl identifier = new GmlObjectIdImpl(sf.getID());
                            geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                            sf.setDefaultGeometryProperty((GeometryAttribute)geo);
                            sf.setDefaultGeometry((Object)g);
                        }
                        if (geo != null) {
                            builder.add(geo.getName().getLocalPart(), geo.getType().getBinding());
                        }
                    }
                } else if (GenericFileDataWithGT.isSupportedShapefileType(geomProperty.getType()) && geomProperty.getValue() != null) {
                    builder.add(geomProperty.getName().getLocalPart(), geomProperty.getType().getBinding());
                }
                for (Property prop : sf.getProperties()) {
                    if (prop.getType() instanceof GeometryType || !GenericFileDataWithGT.isSupportedShapefileType(prop.getType()) || prop.getValue() == null) continue;
                    builder.add(prop.getName().getLocalPart(), prop.getType().getBinding());
                }
                type = builder.buildFeatureType();
                ShapefileDataStore dataStore = new ShapefileDataStore(shp.toURI().toURL());
                dataStore.createSchema(type);
                dataStore.forceSchemaCRS(type.getCoordinateReferenceSystem());
                String typeName = dataStore.getTypeNames()[0];
                store = (FeatureStore)dataStore.getFeatureSource(typeName);
                store.setTransaction((Transaction)transaction);
                build = new SimpleFeatureBuilder(type);
                modifiedFeatureCollection = new DefaultFeatureCollection("fc", type);
            }
            for (AttributeType attributeType : type.getTypes()) {
                build.add(sf.getProperty(attributeType.getName()).getValue());
            }
            SimpleFeature newSf = build.buildFeature(sf.getIdentifier().getID());
            modifiedFeatureCollection.add((Feature)newSf);
        }
        try {
            store.addFeatures(modifiedFeatureCollection);
            transaction.commit();
            sf = shp;
            return sf;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            transaction.rollback();
            throw new IOException(e1.getMessage());
        }
        finally {
            transaction.close();
        }
    }

    private static boolean isSupportedShapefileType(PropertyType type) {
        String[] supported;
        for (String iter : supported = new String[]{"String", "Integer", "Double", "Boolean", "Date", "LineString", "MultiLineString", "Polygon", "MultiPolygon", "Point", "MultiPoint", "Long"}) {
            if (!type.getBinding().getSimpleName().equalsIgnoreCase(iter)) continue;
            return true;
        }
        return false;
    }

    public String writeData(File workspaceDir) {
        String fileName = null;
        if (GenericFileDataConstants.getIncludeFilesByMimeType((String)this.mimeType) != null) {
            try {
                fileName = this.unzipData(this.dataStream, this.fileExtension, workspaceDir);
            }
            catch (IOException e) {
                LOGGER.error("Could not unzip the archive to " + workspaceDir);
            }
        } else {
            try {
                fileName = this.justWriteData(this.dataStream, this.fileExtension, workspaceDir);
            }
            catch (IOException e) {
                LOGGER.error("Could not write the input to " + workspaceDir);
            }
        }
        return fileName;
    }

    private String unzipData(InputStream is, String extension, File writeDirectory) throws IOException {
        ZipEntry entry;
        String baseFileName = UUID.randomUUID().toString();
        ZipInputStream zipInputStream = new ZipInputStream(is);
        String returnFile = null;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String currentExtension = entry.getName();
            int beginIndex = currentExtension.lastIndexOf(".") + 1;
            currentExtension = currentExtension.substring(beginIndex);
            String fileName = baseFileName + "." + currentExtension;
            File currentFile = new File(writeDirectory, fileName);
            if (!writeDirectory.exists()) {
                writeDirectory.mkdir();
            }
            currentFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(currentFile);
            org.apache.commons.io.IOUtils.copy((InputStream)zipInputStream, (OutputStream)fos);
            if (currentExtension.equalsIgnoreCase(extension)) {
                returnFile = currentFile.getAbsolutePath();
            }
            fos.close();
        }
        zipInputStream.close();
        return returnFile;
    }

    private String justWriteData(InputStream is, String extension, File writeDirectory) throws IOException {
        String fileName = null;
        String baseFileName = UUID.randomUUID().toString();
        fileName = baseFileName + "." + extension;
        File currentFile = new File(writeDirectory, fileName);
        if (!writeDirectory.exists()) {
            writeDirectory.mkdir();
        }
        currentFile.createNewFile();
        fileName = currentFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(currentFile);
        org.apache.commons.io.IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        is.close();
        System.gc();
        return fileName;
    }

    public GTVectorDataBinding getAsGTVectorDataBinding() {
        if (this.mimeType.equals("application/x-zipped-shp")) {
            String tmpDirPath = System.getProperty("java.io.tmpdir");
            String dirName = tmpDirPath + File.separator + "tmp" + UUID.randomUUID();
            File tempDir = null;
            if (new File(dirName).mkdir()) {
                tempDir = new File(dirName);
            }
            LOGGER.info("Writing temp data to: " + tempDir);
            String fileName = this.writeData(tempDir);
            LOGGER.info("Temp file is: " + fileName);
            File shpFile = new File(fileName);
            try {
                ShapefileDataStore store = new ShapefileDataStore(shpFile.toURI().toURL());
                SimpleFeatureCollection features = store.getFeatureSource(store.getTypeNames()[0]).getFeatures();
                System.gc();
                tempDir.delete();
                return new GTVectorDataBinding((FeatureCollection<?, ?>)features);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Something went wrong while creating data store.");
                throw new RuntimeException("Something went wrong while creating data store.", e);
            }
            catch (IOException e) {
                LOGGER.error("Something went wrong while converting shapefile to FeatureCollection");
                throw new RuntimeException("Something went wrong while converting shapefile to FeatureCollection", e);
            }
        }
        if (this.mimeType.equals("text/xml; subtype=gml/2.0.0") || this.mimeType.equals("text/xml; subtype=gml/2.1.1") || this.mimeType.equals("text/xml; subtype=gml/2.1.2") || this.mimeType.equals("text/xml; subtype=gml/2.1.2.1")) {
            GML2BasicParser parser = new GML2BasicParser();
            return parser.parse(this.getDataStream(), this.mimeType, null);
        }
        if (this.mimeType.equals("text/xml; subtype=gml/3.0.0") || this.mimeType.equals("text/xml; subtype=gml/3.0.1") || this.mimeType.equals("text/xml; subtype=gml/3.1.0") || this.mimeType.equals("text/xml; subtype=gml/3.1.1") || this.mimeType.equals("text/xml; subtype=gml/3.2.1")) {
            GML3BasicParser parser = new GML3BasicParser();
            return parser.parse(this.getDataStream(), this.mimeType, null);
        }
        throw new RuntimeException("Could not create GTVectorDataBinding for Input");
    }

    public File getShpFile() {
        return this.getAsGTVectorDataBinding().getPayloadAsShpFile();
    }

    public File getBaseFile(boolean unzipIfPossible) {
        String extension = this.fileExtension;
        if (this.primaryFile == null && this.dataStream != null) {
            try {
                int len;
                if (this.fileExtension.equals("shp")) {
                    extension = "zip";
                }
                this.primaryFile = File.createTempFile(UUID.randomUUID().toString(), "." + extension);
                FileOutputStream out = new FileOutputStream(this.primaryFile);
                byte[] buf = new byte[1024];
                while ((len = this.dataStream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("Something went wrong while writing the input stream to the file system", e);
            }
        }
        if (unzipIfPossible && extension.contains("zip")) {
            try {
                File[] files;
                ZipEntry entry;
                File tempFile1 = File.createTempFile(UUID.randomUUID().toString(), "");
                File dir = new File(tempFile1.getParentFile() + "/" + UUID.randomUUID().toString());
                dir.mkdir();
                FileInputStream fis = new FileInputStream(this.primaryFile);
                ZipInputStream zis = new ZipInputStream(fis);
                while ((entry = zis.getNextEntry()) != null) {
                    LOGGER.debug("Extracting: " + entry);
                    FileOutputStream fos = new FileOutputStream(dir.getAbsoluteFile() + "/" + entry.getName());
                    org.apache.commons.io.IOUtils.copy((InputStream)zis, (OutputStream)fos);
                }
                zis.close();
                for (File file : files = dir.listFiles()) {
                    if (!file.getName().contains(".shp") && !file.getName().contains(".SHP")) continue;
                    this.primaryFile = file;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("Error while unzipping input data", e);
            }
        }
        return this.primaryFile;
    }

    protected void finalize() {
        try {
            if (this.primaryFile != null) {
                this.primaryFile.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }
}

