/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class LargeBufferStream
extends OutputStream {
    private static final int DEFAULT_IN_CORE_LIMIT = 0x8000000;
    private ArrayList<Block> blocks = new ArrayList(this.inCoreLimit / 0x800000);
    private int inCoreLimit = 0x8000000;
    private File onDiskFile;
    private OutputStream diskOut;

    public LargeBufferStream() {
        this.blocks.add(new Block());
    }

    @Override
    public void write(int b) throws IOException {
        if (this.blocks == null) {
            this.diskOut.write(b);
            return;
        }
        Block s = this.last();
        if (s.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.diskOut.write(b);
                return;
            }
            s = new Block();
            this.blocks.add(s);
        }
        s.buffer[s.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.blocks != null) {
            while (len > 0) {
                Block s = this.last();
                if (s.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s = new Block();
                    this.blocks.add(s);
                }
                int n = Math.min(0x800000 - s.count, len);
                System.arraycopy(b, off, s.buffer, s.count, n);
                s.count += n;
                len -= n;
                off += n;
            }
        }
        if (len > 0) {
            this.diskOut.write(b, off, len);
        }
    }

    private Block last() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() throws IOException {
        if (this.blocks.size() * 0x800000 < this.inCoreLimit) {
            return false;
        }
        this.onDiskFile = File.createTempFile("jgit_", ".buffer");
        this.diskOut = new FileOutputStream(this.onDiskFile);
        Block last = this.blocks.remove(this.blocks.size() - 1);
        for (Block b : this.blocks) {
            this.diskOut.write(b.buffer, 0, b.count);
        }
        this.blocks = null;
        this.diskOut = new BufferedOutputStream(this.diskOut, 0x800000);
        this.diskOut.write(last.buffer, 0, last.count);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.diskOut != null) {
            try {
                this.diskOut.close();
            }
            finally {
                this.diskOut = null;
            }
        }
    }

    public long length() {
        if (this.onDiskFile != null) {
            return this.onDiskFile.length();
        }
        Block last = this.last();
        return (long)this.blocks.size() * 0x800000L - (long)(0x800000 - last.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException {
        if (this.blocks != null) {
            for (Block b : this.blocks) {
                os.write(b.buffer, 0, b.count);
            }
        } else {
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                int cnt;
                byte[] buf = new byte[0x800000];
                while ((cnt = in.read(buf)) >= 0) {
                    os.write(buf, 0, cnt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.blocks = null;
        if (this.diskOut != null) {
            try {
                this.diskOut.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.diskOut = null;
            }
        }
        if (this.onDiskFile != null) {
            if (!this.onDiskFile.delete()) {
                this.onDiskFile.deleteOnExit();
            }
            this.onDiskFile = null;
        }
    }

    private static class Block {
        static final int SZ = 0x800000;
        final byte[] buffer = new byte[0x800000];
        int count;

        private Block() {
        }

        boolean isFull() {
            return this.count == 0x800000;
        }
    }
}

