/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IOUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeBase64ToFile(InputStream input, String extension) throws IOException {
        File file = File.createTempFile("file" + UUID.randomUUID(), "." + extension, new File(System.getProperty("java.io.tmpdir")));
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            org.apache.commons.io.IOUtils.copyLarge((InputStream)new Base64InputStream(input), (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            org.apache.commons.io.IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        org.apache.commons.io.IOUtils.closeQuietly((OutputStream)outputStream);
        return file;
    }

    public static File writeStreamToFile(InputStream inputStream, String extension) throws IOException {
        File file = File.createTempFile("file" + UUID.randomUUID(), "." + extension);
        return IOUtils.writeStreamToFile(inputStream, extension, file);
    }

    public static File writeStreamToFile(InputStream inputStream, String extension, File file) throws IOException {
        int len;
        FileOutputStream output = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            output.write(buf, 0, len);
        }
        output.close();
        inputStream.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeBase64XMLToFile(InputStream stream, String extension) throws SAXException, IOException, ParserConfigurationException, DOMException, TransformerException {
        File file;
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        String binaryContent = XPathAPI.selectSingleNode((Node)document.getFirstChild(), (String)"text()").getTextContent();
        ByteArrayInputStream byteStream = null;
        try {
            byteStream = new ByteArrayInputStream(binaryContent.getBytes());
            file = IOUtils.writeBase64ToFile(byteStream, extension);
        }
        catch (Throwable throwable) {
            org.apache.commons.io.IOUtils.closeQuietly(byteStream);
            throw throwable;
        }
        org.apache.commons.io.IOUtils.closeQuietly((InputStream)byteStream);
        return file;
    }

    public static File zip(File ... files) throws IOException {
        File zip = File.createTempFile("zip" + UUID.randomUUID(), ".zip");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        byte[] buffer = new byte[4096];
        for (File file : files) {
            int len;
            if (!file.exists()) {
                LOGGER.debug("Could not zip " + file.getAbsolutePath());
                continue;
            }
            out.putNextEntry(new ZipEntry(file.getName()));
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        IOUtils.deleteResources(files);
        out.close();
        return zip;
    }

    public static List<File> unzip(File file, String extension) throws IOException {
        return IOUtils.unzip(file, extension, null);
    }

    public static List<File> unzip(File file, String extension, File directory) throws IOException {
        ZipEntry entry;
        int bufferLength = 2048;
        byte[] buffer = new byte[bufferLength];
        ArrayList<File> foundFiles = new ArrayList<File>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        File tempDir = directory;
        if (tempDir == null || !directory.isDirectory()) {
            tempDir = File.createTempFile("unzipped" + UUID.randomUUID(), "", new File(System.getProperty("java.io.tmpdir")));
            tempDir.delete();
            tempDir.mkdir();
        }
        while ((entry = zipInputStream.getNextEntry()) != null) {
            int count;
            File entryFile = new File(tempDir, entry.getName());
            entryFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(entryFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, bufferLength);
            while ((count = zipInputStream.read(buffer, 0, bufferLength)) != -1) {
                dest.write(buffer, 0, count);
            }
            dest.flush();
            dest.close();
            if (!entry.getName().endsWith("." + extension)) continue;
            foundFiles.add(entryFile);
        }
        zipInputStream.close();
        IOUtils.deleteResources(file);
        return foundFiles;
    }

    public static List<File> unzipAll(File file) throws IOException {
        ZipEntry entry;
        int bufferLength = 2048;
        byte[] buffer = new byte[bufferLength];
        ArrayList<File> foundFiles = new ArrayList<File>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        File tempDir = File.createTempFile("unzipped" + UUID.randomUUID(), "", new File(System.getProperty("java.io.tmpdir")));
        tempDir.delete();
        tempDir.mkdir();
        while ((entry = zipInputStream.getNextEntry()) != null) {
            int count;
            File entryFile = new File(tempDir, entry.getName());
            entryFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(entryFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, bufferLength);
            while ((count = zipInputStream.read(buffer, 0, bufferLength)) != -1) {
                dest.write(buffer, 0, count);
            }
            dest.flush();
            dest.close();
            foundFiles.add(entryFile);
        }
        zipInputStream.close();
        IOUtils.deleteResources(file);
        return foundFiles;
    }

    public static void deleteResources(File ... files) {
        for (File file : files) {
            if (file == null || !file.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) continue;
            IOUtils.delete(file);
            File parent = file.getAbsoluteFile().getParentFile();
            if (parent == null || parent.getAbsolutePath().equals(System.getProperty("java.io.tmpdir"))) continue;
            parent.deleteOnExit();
        }
    }

    private static void delete(File ... files) {
        for (File file : files) {
            File[] list;
            if (file == null) continue;
            final String baseName = file.getName().substring(0, file.getName().lastIndexOf("."));
            for (File f : list = file.getAbsoluteFile().getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(baseName);
                }
            })) {
                f.deleteOnExit();
            }
            file.deleteOnExit();
        }
    }
}

