/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.n52.wps.GeneratorDocument;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.IGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorFactory {
    public static String PROPERTY_NAME_REGISTERED_GENERATORS = "registeredGenerators";
    private static GeneratorFactory factory;
    private static Logger LOGGER;
    private List<IGenerator> registeredGenerators;

    public static void initialize(GeneratorDocument.Generator[] generators) {
        if (factory == null) {
            factory = new GeneratorFactory(generators);
        } else {
            LOGGER.warn("Factory already initialized");
        }
    }

    private GeneratorFactory(GeneratorDocument.Generator[] generators) {
        this.loadAllGenerators(generators);
        WPSConfig.getInstance().addPropertyChangeListener("WPSConfigUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LOGGER.info(this.getClass().getName() + ": Received Property Change Event: " + propertyChangeEvent.getPropertyName());
                GeneratorFactory.this.loadAllGenerators(WPSConfig.getInstance().getActiveRegisteredGenerator());
            }
        });
    }

    private void loadAllGenerators(GeneratorDocument.Generator[] generators) {
        this.registeredGenerators = new ArrayList<IGenerator>();
        for (GeneratorDocument.Generator currentGenerator : generators) {
            PropertyDocument.Property[] activeProperties = new PropertyDocument.Property[]{};
            ArrayList<PropertyDocument.Property> activeProps = new ArrayList<PropertyDocument.Property>();
            for (int i = 0; i < currentGenerator.getPropertyArray().length; ++i) {
                if (!currentGenerator.getPropertyArray()[i].getActive()) continue;
                activeProps.add(currentGenerator.getPropertyArray()[i]);
            }
            currentGenerator.setPropertyArray(activeProps.toArray(activeProperties));
            IGenerator generator = null;
            String generatorClass = currentGenerator.getClassName();
            try {
                generator = (IGenerator)this.getClass().getClassLoader().loadClass(generatorClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("One of the generators could not be loaded: " + generatorClass, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("One of the generators could not be loaded: " + generatorClass, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("One of the generators could not be loaded: " + generatorClass, (Throwable)e);
            }
            if (generator == null) continue;
            LOGGER.info("Generator class registered: " + generatorClass);
            this.registeredGenerators.add(generator);
        }
    }

    public static GeneratorFactory getInstance() {
        if (factory == null) {
            GeneratorDocument.Generator[] generators = WPSConfig.getInstance().getActiveRegisteredGenerator();
            GeneratorFactory.initialize(generators);
        }
        return factory;
    }

    public IGenerator getGenerator(String schema, String format, String encoding, Class<?> outputInternalClass) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        for (IGenerator generator : this.registeredGenerators) {
            Class<?>[] supportedBindings;
            for (Class<?> clazz : supportedBindings = generator.getSupportedDataBindings()) {
                if (!clazz.equals(outputInternalClass) || !generator.isSupportedSchema(schema) || !generator.isSupportedEncoding(encoding) || !generator.isSupportedFormat(format)) continue;
                return generator;
            }
        }
        return null;
    }

    public List<IGenerator> getAllGenerators() {
        return this.registeredGenerators;
    }

    static {
        LOGGER = LoggerFactory.getLogger(GeneratorFactory.class);
    }
}

