/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.xmlbeans.impl.util.Base64;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.io.data.binding.literal.LiteralAnyURIBinding;
import org.n52.wps.io.data.binding.literal.LiteralBase64BinaryBinding;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralByteBinding;
import org.n52.wps.io.data.binding.literal.LiteralDateTimeBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralLongBinding;
import org.n52.wps.io.data.binding.literal.LiteralShortBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicXMLTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicXMLTypeFactory.class);
    public static final String DOUBLE_URI = "xs:double";
    public static final String FLOAT_URI = "xs:float";
    public static final String INTEGER_URI = "xs:integer";
    public static final String LONG_URI = "xs:long";
    public static final String INT_URI = "xs:int";
    public static final String SHORT_URI = "xs:short";
    public static final String BYTE_URI = "xs:byte";
    public static final String BOOLEAN_URI = "xs:boolean";
    public static final String STRING_URI = "xs:string";
    public static final String DATETIME_URI = "xs:dateTime";
    public static final String DATE_URI = "xs:date";
    public static final String BASE64BINARY_URI = "xs:base64Binary";
    public static final String ANYURI_URI = "xs:anyURI";
    private static final DatatypeFactory DATATYPE_FACTORY;

    private BasicXMLTypeFactory() {
    }

    public static IData getBasicJavaObject(String xmlDataTypeURI, String obj) {
        obj = obj.replace('\n', ' ').replace('\t', ' ').trim();
        if (xmlDataTypeURI == null) {
            return new LiteralStringBinding(obj);
        }
        if (xmlDataTypeURI.equalsIgnoreCase(FLOAT_URI)) {
            return new LiteralFloatBinding(Float.valueOf(Float.parseFloat(obj)));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(DOUBLE_URI)) {
            return new LiteralDoubleBinding(Double.parseDouble(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(LONG_URI)) {
            return new LiteralLongBinding(Long.parseLong(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(INT_URI) || xmlDataTypeURI.equalsIgnoreCase(INTEGER_URI)) {
            return new LiteralIntBinding(Integer.parseInt(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(SHORT_URI)) {
            return new LiteralShortBinding(Short.parseShort(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(BYTE_URI)) {
            return new LiteralByteBinding(Byte.parseByte(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(BOOLEAN_URI)) {
            return new LiteralBooleanBinding(Boolean.parseBoolean(obj));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(STRING_URI)) {
            return new LiteralStringBinding(obj);
        }
        if (xmlDataTypeURI.equalsIgnoreCase(DATETIME_URI) || xmlDataTypeURI.equalsIgnoreCase(DATE_URI)) {
            try {
                return new LiteralDateTimeBinding(DATATYPE_FACTORY.newXMLGregorianCalendar(obj).toGregorianCalendar().getTime());
            }
            catch (Exception e) {
                LOGGER.error("Could not parse xs:dateTime or xs:date data", (Throwable)e);
                return null;
            }
        }
        if (xmlDataTypeURI.equalsIgnoreCase(BASE64BINARY_URI)) {
            return new LiteralBase64BinaryBinding(Base64.decode((byte[])obj.getBytes()));
        }
        if (xmlDataTypeURI.equalsIgnoreCase(ANYURI_URI)) {
            try {
                return new LiteralAnyURIBinding(new URI(obj));
            }
            catch (URISyntaxException e) {
                LOGGER.error("Could not parse anyURI data", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static String getStringRepresentation(String xmlDataTypeURI, IData obj) {
        return obj.getPayload().toString();
    }

    public static Class<? extends ILiteralData> getBindingForPayloadType(Class<?> payloadType) {
        if (payloadType.equals(Float.TYPE) || payloadType.equals(Float.class)) {
            return LiteralFloatBinding.class;
        }
        if (payloadType.equals(Double.TYPE) || payloadType.equals(Double.class)) {
            return LiteralDoubleBinding.class;
        }
        if (payloadType.equals(Long.TYPE) || payloadType.equals(Long.class)) {
            return LiteralLongBinding.class;
        }
        if (payloadType.equals(Integer.TYPE) || payloadType.equals(Integer.class)) {
            return LiteralIntBinding.class;
        }
        if (payloadType.equals(Short.TYPE) || payloadType.equals(Short.class)) {
            return LiteralShortBinding.class;
        }
        if (payloadType.equals(Byte.TYPE) || payloadType.equals(Byte.class)) {
            return LiteralByteBinding.class;
        }
        if (payloadType.equals(Boolean.TYPE) || payloadType.equals(Boolean.class)) {
            return LiteralBooleanBinding.class;
        }
        if (payloadType.equals(String.class)) {
            return LiteralStringBinding.class;
        }
        if (payloadType.equals(Date.class)) {
            return LiteralDateTimeBinding.class;
        }
        if (payloadType.equals(byte[].class)) {
            return LiteralBase64BinaryBinding.class;
        }
        if (payloadType.equals(URI.class)) {
            return LiteralAnyURIBinding.class;
        }
        return null;
    }

    public static String getXMLDataTypeforBinding(Class<? extends ILiteralData> clazz) {
        if (LiteralFloatBinding.class.isAssignableFrom(clazz)) {
            return FLOAT_URI;
        }
        if (LiteralDoubleBinding.class.isAssignableFrom(clazz)) {
            return DOUBLE_URI;
        }
        if (LiteralLongBinding.class.isAssignableFrom(clazz)) {
            return LONG_URI;
        }
        if (LiteralIntBinding.class.isAssignableFrom(clazz)) {
            return INT_URI;
        }
        if (LiteralShortBinding.class.isAssignableFrom(clazz)) {
            return SHORT_URI;
        }
        if (LiteralByteBinding.class.isAssignableFrom(clazz)) {
            return BYTE_URI;
        }
        if (LiteralBooleanBinding.class.isAssignableFrom(clazz)) {
            return BOOLEAN_URI;
        }
        if (LiteralStringBinding.class.isAssignableFrom(clazz)) {
            return STRING_URI;
        }
        if (LiteralDateTimeBinding.class.isAssignableFrom(clazz)) {
            return DATETIME_URI;
        }
        if (LiteralBase64BinaryBinding.class.isAssignableFrom(clazz)) {
            return BASE64BINARY_URI;
        }
        if (LiteralAnyURIBinding.class.isAssignableFrom(clazz)) {
            return ANYURI_URI;
        }
        return null;
    }

    static {
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            LOGGER.error("Error creating DatatypeFactory for xs:datTime and xs:dateParsing");
        }
        DATATYPE_FACTORY = datatypeFactory;
    }
}

