/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.antlr.HqlBaseParser;
import org.hibernate.hql.internal.antlr.HqlTokenTypes;
import org.hibernate.hql.internal.ast.ErrorCounter;
import org.hibernate.hql.internal.ast.HqlASTFactory;
import org.hibernate.hql.internal.ast.HqlLexer;
import org.hibernate.hql.internal.ast.HqlToken;
import org.hibernate.hql.internal.ast.ParseErrorHandler;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public final class HqlParser
extends HqlBaseParser {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)HqlParser.class.getName());
    private ParseErrorHandler parseErrorHandler;
    private ASTPrinter printer = HqlParser.getASTPrinter();
    private int traceDepth = 0;

    private static ASTPrinter getASTPrinter() {
        return new ASTPrinter(HqlTokenTypes.class);
    }

    public static HqlParser getInstance(String hql) {
        HqlLexer lexer = new HqlLexer(new StringReader(hql));
        return new HqlParser(lexer);
    }

    private HqlParser(TokenStream lexer) {
        super(lexer);
        this.initialize();
    }

    public void traceIn(String ruleName) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        LOG.trace(prefix + ruleName);
    }

    public void traceOut(String ruleName) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(prefix + ruleName);
    }

    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    @Override
    public AST handleIdentifierError(Token token, RecognitionException ex) throws RecognitionException, TokenStreamException {
        HqlToken hqlToken;
        if (token instanceof HqlToken && (hqlToken = (HqlToken)token).isPossibleID() && ex instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)ex;
            if (mte.expecting == 111) {
                this.reportWarning("Keyword  '" + token.getText() + "' is being interpreted as an identifier due to: " + mte.getMessage());
                ASTPair currentAST = new ASTPair();
                token.setType(96);
                this.astFactory.addASTChild(currentAST, this.astFactory.create(token));
                this.consume();
                AST identifierAST = currentAST.root;
                return identifierAST;
            }
        }
        return super.handleIdentifierError(token, ex);
    }

    @Override
    public AST negateNode(AST x) {
        switch (x.getType()) {
            case 40: {
                x.setType(6);
                x.setText("{and}");
                x.setFirstChild(this.negateNode(x.getFirstChild()));
                x.getFirstChild().setNextSibling(this.negateNode(x.getFirstChild().getNextSibling()));
                return x;
            }
            case 6: {
                x.setType(40);
                x.setText("{or}");
                x.setFirstChild(this.negateNode(x.getFirstChild()));
                x.getFirstChild().setNextSibling(this.negateNode(x.getFirstChild().getNextSibling()));
                return x;
            }
            case 105: {
                x.setType(112);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 112: {
                x.setType(105);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 115: {
                x.setType(116);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 114: {
                x.setType(117);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 117: {
                x.setType(114);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 116: {
                x.setType(115);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 34: {
                x.setType(87);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 87: {
                x.setType(34);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 26: {
                x.setType(86);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 86: {
                x.setType(26);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 83: {
                x.setType(82);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 82: {
                x.setType(83);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 10: {
                x.setType(85);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 85: {
                x.setType(10);
                x.setText("{not}" + x.getText());
                return x;
            }
        }
        AST not = super.negateNode(x);
        if (not != x) {
            not.setNextSibling(x.getNextSibling());
            x.setNextSibling(null);
        }
        return not;
    }

    @Override
    public AST processEqualityExpression(AST x) {
        if (x == null) {
            LOG.processEqualityExpression();
            return null;
        }
        int type = x.getType();
        if (type == 105 || type == 112) {
            boolean negated;
            boolean bl = negated = type == 112;
            if (x.getNumberOfChildren() == 2) {
                AST a = x.getFirstChild();
                AST b = a.getNextSibling();
                if (a.getType() == 39 && b.getType() != 39) {
                    return this.createIsNullParent(b, negated);
                }
                if (b.getType() == 39 && a.getType() != 39) {
                    return this.createIsNullParent(a, negated);
                }
                if (b.getType() == 65) {
                    return this.processIsEmpty(a, negated);
                }
                return x;
            }
            return x;
        }
        return x;
    }

    private AST createIsNullParent(AST node, boolean negated) {
        node.setNextSibling(null);
        int type = negated ? 82 : 83;
        String text = negated ? "is not null" : "is null";
        return ASTUtil.createParent(this.astFactory, type, text, node);
    }

    private AST processIsEmpty(AST node, boolean negated) {
        node.setNextSibling(null);
        AST ast = this.createSubquery(node);
        ast = ASTUtil.createParent(this.astFactory, 19, "exists", ast);
        if (!negated) {
            ast = ASTUtil.createParent(this.astFactory, 38, "not", ast);
        }
        return ast;
    }

    private AST createSubquery(AST node) {
        AST ast = ASTUtil.createParent(this.astFactory, 90, "RANGE", node);
        ast = ASTUtil.createParent(this.astFactory, 22, "from", ast);
        ast = ASTUtil.createParent(this.astFactory, 92, "SELECT_FROM", ast);
        ast = ASTUtil.createParent(this.astFactory, 89, "QUERY", ast);
        return ast;
    }

    public void showAst(AST ast, PrintStream out) {
        this.showAst(ast, new PrintWriter(out));
    }

    private void showAst(AST ast, PrintWriter pw) {
        this.printer.showAst(ast, pw);
    }

    private void initialize() {
        this.parseErrorHandler = new ErrorCounter();
        this.setASTFactory(new HqlASTFactory());
    }

    @Override
    public void weakKeywords() throws TokenStreamException {
        int t = this.LA(1);
        switch (t) {
            case 24: 
            case 41: {
                if (this.LA(2) == 108) break;
                this.LT(1).setType(111);
                if (!LOG.isDebugEnabled()) break;
                LOG.debugf("weakKeywords() : new LT(1) token - %s", this.LT(1));
                break;
            }
            default: {
                HqlToken hqlToken;
                if (this.LA(0) != 22 || t == 111 || this.LA(2) != 15 || !(hqlToken = (HqlToken)this.LT(1)).isPossibleID()) break;
                hqlToken.setType(111);
                if (!LOG.isDebugEnabled()) break;
                LOG.debugf("weakKeywords() : new LT(1) token - %s", this.LT(1));
            }
        }
    }

    @Override
    public void handleDotIdent() throws TokenStreamException {
        HqlToken t;
        if (this.LA(1) == 15 && this.LA(2) != 111 && (t = (HqlToken)this.LT(2)).isPossibleID()) {
            this.LT(2).setType(111);
            if (LOG.isDebugEnabled()) {
                LOG.debugf("handleDotIdent() : new LT(2) token - %s", this.LT(1));
            }
        }
    }

    @Override
    public void processMemberOf(Token n, AST p, ASTPair currentAST) {
        AST inNode = n == null ? this.astFactory.create(26, "in") : this.astFactory.create(86, "not in");
        this.astFactory.makeASTRoot(currentAST, inNode);
        AST inListNode = this.astFactory.create(80, "inList");
        inNode.addChild(inListNode);
        AST elementsNode = this.astFactory.create(17, "elements");
        inListNode.addChild(elementsNode);
        elementsNode.addChild(p);
    }

    public static void panic() {
        throw new QueryException("Parser: panic");
    }
}

