/*
 * Decompiled with CFR 0.152.
 */
package com.sample;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.test.JBPMHelper;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class ProcessMain {
    public static void main(String[] args) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kContainer = ks.getKieClasspathContainer();
        KieBase kbase = kContainer.getKieBase("kbase");
        RuntimeManager manager = ProcessMain.createRuntimeManager(kbase);
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ksession.startProcess("com.sample.bpmn.hello");
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        System.out.println("John is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        System.out.println("Mary is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        manager.disposeRuntimeEngine(engine);
        System.exit(0);
    }

    private static RuntimeManager createRuntimeManager(KieBase kbase) {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).knowledgeBase(kbase);
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(builder.get(), "com.sample:example:1.0");
    }
}

