/*
 * Decompiled with CFR 0.152.
 */
package cobweb.m24;

import cobweb.m24.ExecuteRequestBuilder;
import cobweb.m24.ExecuteResponseAnalyser;
import java.io.IOException;
import java.util.HashMap;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.DataType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.opengis.feature.simple.SimpleFeature;

public class GenericWPSConflationClient {
    String wpsURL;
    String wpsProcessID;
    HashMap<String, Object> wpsInputs;
    HashMap<String, Object> outputs;
    String catalogURL;
    FeatureCollection featureCollection;
    FeatureCollection inputFeatureCollection;

    public GenericWPSConflationClient(String wpsURL, String wpsProcessID, HashMap<String, Object> wpsInputs, String catalogURL) {
        this.wpsURL = wpsURL;
        this.wpsProcessID = wpsProcessID;
        this.wpsInputs = wpsInputs;
        this.catalogURL = catalogURL;
        System.out.println("WPS URL " + wpsURL);
        System.out.println("WPS Process ID " + wpsProcessID);
        try {
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, wpsProcessID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            CapabilitiesDocument capabilitiesDocument = this.requestGetCapabilities(wpsURL);
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, wpsProcessID);
            this.outputs = this.executeProcess(wpsURL, wpsProcessID, describeProcessDocument, wpsInputs);
            Object result = this.outputs.get("OUT_TARGET");
            System.out.println("Result " + result.toString());
            if (result instanceof GTVectorDataBinding) {
                System.out.println("inputData = GTVECTORDATABINDING");
                FeatureCollection out = ((GTVectorDataBinding)result).getPayload();
                System.out.println("result number " + out.size());
                SimpleFeatureIterator fit = (SimpleFeatureIterator)out.features();
                System.out.println("result F " + ((SimpleFeature)fit.next()).toString());
                fit.close();
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        ProcessBriefType[] processList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        InputDescriptionType[] inputList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        for (InputDescriptionType input : inputList = processDescription.getDataInputs().getInputArray()) {
            System.out.println(input.getIdentifier().getStringValue());
        }
        return processDescription;
    }

    public HashMap<String, Object> executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, Object> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String inputName = input.getIdentifier().getStringValue();
            Object inputValue = inputs.get(inputName);
            if (input.getLiteralData() != null) {
                if (!(inputValue instanceof String)) continue;
                executeBuilder.addLiteralData(inputName, (String)inputValue);
                continue;
            }
            if (input.getComplexData() == null) continue;
            if (inputValue instanceof FeatureCollection) {
                System.out.println("Feature Collection " + inputName + " " + inputValue);
                GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.0.0/base/feature.xsd", null, "text/xml; subtype=gml/3.0.0");
            }
            if (inputValue instanceof String) {
                System.out.println("Feature Collection reference " + inputName + " " + inputValue);
                executeBuilder.addComplexDataReference(inputName, (String)inputValue, "http://schemas.opengis.net/gml/3.0.0/base/feature.xsd", null, "text/xml; subtype=gml/3.0.0");
            }
            if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
            throw new IOException("Property not set, but mandatory: " + inputName);
        }
        executeBuilder.setMimeTypeForOutput("text/xml; subtype=gml/3.0.0", "OUT_TARGET");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.0.0/base/feature.xsd", "OUT_TARGET");
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            DataType dataType = response.getExecuteResponse().getProcessOutputs().getOutputArray(0).getData();
            System.out.println("data output " + dataType.toString());
            HashMap<String, Object> dataReturn = new HashMap<String, Object>();
            IData data = analyser.getComplexData("OUT_TARGET", GTVectorDataBinding.class);
            System.out.println(dataType.toString());
            dataReturn.put("OUT_TARGET", data);
            return dataReturn;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public HashMap<String, Object> getOutputs() {
        return this.outputs;
    }
}

