/*
 * Decompiled with CFR 0.152.
 */
package cobweb.m24;

import cobweb.m24.ExecuteResponseAnalyser;
import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.ExecuteRequestBuilder;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.opengis.feature.simple.SimpleFeature;

public class GenericWPSClient {
    String wpsURL;
    String wpsProcessID;
    HashMap<String, Object> wpsInputs;
    HashMap<String, Object> outputs;
    String catalogURL;
    FeatureCollection featureCollection;
    FeatureCollection inputFeatureCollection;

    public GenericWPSClient(String wpsURL, String wpsProcessID, HashMap<String, Object> wpsInputs, String catalogURL) {
        this.wpsURL = wpsURL;
        this.wpsProcessID = wpsProcessID;
        this.wpsInputs = wpsInputs;
        this.catalogURL = catalogURL;
        System.out.println("WPS URL " + wpsURL);
        System.out.println("WPS Process ID " + wpsProcessID);
        try {
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, wpsProcessID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            SimpleFeatureIterator fit;
            CapabilitiesDocument capabilitiesDocument = this.requestGetCapabilities(wpsURL);
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, wpsProcessID);
            this.outputs = this.executeProcess(wpsURL, wpsProcessID, describeProcessDocument, wpsInputs);
            Object result = this.outputs.get("result");
            Object qual_result = this.outputs.get("qual_result");
            if (result instanceof GTVectorDataBinding) {
                System.out.println("inputData = GTVECTORDATABINDING");
                FeatureCollection out = ((GTVectorDataBinding)result).getPayload();
                System.out.println("result number " + out.size());
                fit = (SimpleFeatureIterator)out.features();
                System.out.println("result F " + ((SimpleFeature)fit.next()).toString());
                fit.close();
            }
            if (qual_result instanceof GTVectorDataBinding) {
                FeatureCollection qual_out = ((GTVectorDataBinding)qual_result).getPayload();
                System.out.println("qual result number " + qual_out.size());
                fit = (SimpleFeatureIterator)qual_out.features();
                System.out.println("result F " + ((SimpleFeature)fit.next()).toString());
                fit.close();
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        ProcessBriefType[] processList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        InputDescriptionType[] inputList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        for (InputDescriptionType input : inputList = processDescription.getDataInputs().getInputArray()) {
            System.out.println(input.getIdentifier().getStringValue());
        }
        return processDescription;
    }

    public HashMap<String, Object> executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, Object> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String inputName = input.getIdentifier().getStringValue();
            Object inputValue = inputs.get(inputName);
            if (input.getLiteralData() != null) {
                if (inputValue instanceof String) {
                    executeBuilder.addLiteralData(inputName, (String)inputValue);
                }
            } else if (input.getComplexData() != null) {
                System.out.println("HERE 3 " + inputName);
                if (inputValue instanceof FeatureCollection) {
                    GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                    executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", null, "text/xml; subtype=gml/3.1.0");
                }
                if (inputValue instanceof String) {
                    executeBuilder.addComplexDataReference(inputName, (String)inputValue, "http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", null, "text/xml; subtype=gml/3.1.0");
                }
            }
            if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
            throw new IOException("Property not set, but mandatory: " + inputName);
        }
        executeBuilder.setMimeTypeForOutput("text/xml; subtype=gml/3.1.0", "result");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", "result");
        executeBuilder.setMimeTypeForOutput("text/xml; subtype=gml/3.1.0", "qual_result");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", "qual_result");
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            System.out.println("HERE 6");
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object[] dataReturn = new Object[3];
            IData data = analyser.getComplexData("result", GTVectorDataBinding.class);
            result.put("result", data);
            IData data2 = null;
            if (analyser.getComplexData("qual_result", GTVectorDataBinding.class) != null) {
                data2 = analyser.getComplexData("qual_result", GTVectorDataBinding.class);
            }
            System.out.println("HERE 6 " + data2.toString());
            result.put("qual_result", data2);
            return result;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public HashMap<String, Object> getOutputs() {
        return this.outputs;
    }

    private void insertGVQMetadata(File file, String geonetworkURL) throws GNServerException, GNLibException {
        String un = "admin";
        String pw = "admin";
        GNClient client = new GNClient(geonetworkURL);
        client.login(un, pw);
        GNInsertConfiguration cfg = new GNInsertConfiguration();
        cfg.setCategory("datasets");
        cfg.setGroup("1");
        cfg.setStyleSheet("_none_");
        cfg.setValidate(Boolean.FALSE);
        long id = client.insertMetadata(cfg, file);
        System.out.println("Metadata created with id " + id);
    }

    private File parseXMLFromWPS(GenericFileData xmlGenericData) {
        File file = xmlGenericData.getBaseFile(true);
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            File newFile = File.createTempFile("temp2", "xml");
            FileWriter fw = new FileWriter(newFile);
            String line = br.readLine();
            while (line != null) {
                String newLine = line.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&");
                System.out.println("NEWLINE " + newLine);
                fw.write(newLine);
                line = br.readLine();
            }
            fw.close();
            ((InputStream)fis).close();
            return newFile;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

