/*
 * Decompiled with CFR 0.152.
 */
package cobweb.m24;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.DocumentOutputDefinitionType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.InputReferenceType;
import net.opengis.wps.x100.InputType;
import net.opengis.wps.x100.LiteralDataType;
import net.opengis.wps.x100.OutputDefinitionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ResponseDocumentType;
import net.opengis.wps.x100.ResponseFormType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.n52.wps.client.StaticDataHandlerRepository;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.data.IData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteRequestBuilder {
    ProcessDescriptionType processDesc;
    ExecuteDocument execute;
    String SUPPORTED_VERSION = "1.0.0";
    private static Logger LOGGER = LoggerFactory.getLogger(ExecuteRequestBuilder.class);

    public ExecuteRequestBuilder(ProcessDescriptionType processDesc) {
        this.processDesc = processDesc;
        this.execute = ExecuteDocument.Factory.newInstance();
        ExecuteDocument.Execute ex = this.execute.addNewExecute();
        ex.setService("WPS");
        ex.setVersion(this.SUPPORTED_VERSION);
        ex.addNewIdentifier().setStringValue(processDesc.getIdentifier().getStringValue());
        ex.addNewDataInputs();
    }

    public ExecuteRequestBuilder(ProcessDescriptionType processDesc, ExecuteDocument execute) {
        this.processDesc = processDesc;
        this.execute = execute;
    }

    public void addComplexData(String parameterID, IData value, String schema, String encoding, String mimeType) throws WPSClientException {
        GeneratorFactory fac = StaticDataHandlerRepository.getGeneratorFactory();
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDesription is null for: " + parameterID);
        }
        if (inputDesc.getComplexData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type ComplexData: " + parameterID);
        }
        LOGGER.debug("Looking for matching Generator ... schema: " + schema + " mimeType: " + mimeType + " encoding: " + encoding);
        IGenerator generator = fac.getGenerator(schema, mimeType, encoding, value.getClass());
        if (generator == null) {
            throw new IllegalArgumentException("Could not find an appropriate generator for parameter: " + parameterID);
        }
        InputStream stream = null;
        InputType input = this.execute.getExecute().getDataInputs().addNewInput();
        input.addNewIdentifier().setStringValue(inputDesc.getIdentifier().getStringValue());
        try {
            if (encoding == null || encoding.equals("") || encoding.equalsIgnoreCase("UTF-8")) {
                stream = generator.generateStream(value, mimeType, schema);
            } else if (encoding.equalsIgnoreCase("base64")) {
                stream = generator.generateBase64Stream(value, mimeType, schema);
            } else {
                throw new WPSClientException("Encoding not supported");
            }
            ComplexDataType data = input.addNewData().addNewComplexData();
            if (mimeType.contains("xml")) {
                data.set(XmlObject.Factory.parse((InputStream)stream));
            } else {
                String text = "";
                int i = -1;
                while ((i = stream.read()) != -1) {
                    text = text + (char)i;
                }
                XmlString xml = XmlString.Factory.newInstance();
                xml.setStringValue(text);
                data.set((XmlObject)xml);
            }
            if (schema != null) {
                data.setSchema(schema);
            }
            if (mimeType != null) {
                data.setMimeType(mimeType);
            }
            if (encoding != null) {
                data.setEncoding(encoding);
            }
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("error inserting node into execute request", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error reading generator output", e);
        }
    }

    public void addComplexData(String parameterID, String value, String schema, String encoding, String mimeType) throws WPSClientException {
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDesription is null for: " + parameterID);
        }
        if (inputDesc.getComplexData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type ComplexData: " + parameterID);
        }
        InputType input = this.execute.getExecute().getDataInputs().addNewInput();
        input.addNewIdentifier().setStringValue(inputDesc.getIdentifier().getStringValue());
        try {
            ComplexDataType data = input.addNewData().addNewComplexData();
            XmlOptions xmlOptions = new XmlOptions();
            data.set(XmlObject.Factory.parse((String)value, (XmlOptions)xmlOptions));
            if (schema != null) {
                data.setSchema(schema);
            }
            if (mimeType != null) {
                data.setMimeType(mimeType);
            }
            if (encoding != null) {
                data.setEncoding(encoding);
            }
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("error inserting node into execute request", e);
        }
    }

    public void addComplexData(String parameterID, String value, String schema, String encoding, String mimeType, boolean asReference) throws WPSClientException {
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDescription is null for: " + parameterID);
        }
        if (inputDesc.getComplexData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type ComplexData: " + parameterID);
        }
        InputType input = this.execute.getExecute().getDataInputs().addNewInput();
        input.addNewIdentifier().setStringValue(inputDesc.getIdentifier().getStringValue());
        try {
            ComplexDataType data = input.addNewData().addNewComplexData();
            XmlOptions xmlOptions = new XmlOptions();
            data.set(XmlObject.Factory.parse((String)value, (XmlOptions)xmlOptions));
            if (schema != null) {
                data.setSchema(schema);
            }
            if (mimeType != null) {
                data.setMimeType(mimeType);
            }
            if (encoding != null) {
                data.setEncoding(encoding);
            }
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("error inserting node into execute request", e);
        }
    }

    public void addComplexData(InputType inputType) {
        String parameterID = inputType.getIdentifier().getStringValue();
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDescription is null for: " + parameterID);
        }
        if (inputDesc.getComplexData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type ComplexData: " + parameterID);
        }
        InputType[] currentInputTypeArray = this.execute.getExecute().getDataInputs().getInputArray();
        InputType[] newInputTypeArray = currentInputTypeArray != null ? Arrays.copyOf(currentInputTypeArray, currentInputTypeArray.length + 1) : new InputType[1];
        newInputTypeArray[newInputTypeArray.length - 1] = inputType;
        this.execute.getExecute().getDataInputs().setInputArray(newInputTypeArray);
    }

    public void addLiteralData(String parameterID, String value) {
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDescription is null for: " + parameterID);
        }
        if (inputDesc.getLiteralData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type literalData: " + parameterID);
        }
        InputType input = this.execute.getExecute().getDataInputs().addNewInput();
        input.addNewIdentifier().setStringValue(parameterID);
        input.addNewData().addNewLiteralData().setStringValue(value);
        DomainMetadataType dataType = inputDesc.getLiteralData().getDataType();
        if (dataType != null) {
            input.getData().getLiteralData().setDataType(dataType.getReference());
        }
    }

    public void addComplexDataReference(String parameterID, String value, String schema, String encoding, String mimetype) {
        InputDescriptionType inputDesc = this.getParameterDescription(parameterID);
        if (inputDesc == null) {
            throw new IllegalArgumentException("inputDescription is null for: " + parameterID);
        }
        if (inputDesc.getComplexData() == null) {
            throw new IllegalArgumentException("inputDescription is not of type complexData: " + parameterID);
        }
        InputType input = this.execute.getExecute().getDataInputs().addNewInput();
        input.addNewIdentifier().setStringValue(parameterID);
        input.addNewReference().setHref(value);
        if (schema != null) {
            input.getReference().setSchema(schema);
        }
        if (encoding != null) {
            input.getReference().setEncoding(encoding);
        }
        if (mimetype != null) {
            input.getReference().setMimeType(mimetype);
        }
    }

    public boolean isExecuteValid() {
        return true;
    }

    public boolean setStoreSupport(String outputName, boolean storeSupport) {
        ResponseFormType responseForm;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!(responseForm = this.execute.getExecute().getResponseForm()).isSetResponseDocument()) {
            responseForm.addNewResponseDocument();
        }
        ResponseDocumentType responseDocument = responseForm.getResponseDocument();
        responseDocument.setStoreExecuteResponse(storeSupport);
        return true;
    }

    public boolean setAsReference(String outputName, boolean asReference) {
        DocumentOutputDefinitionType outputDef = null;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!this.execute.getExecute().getResponseForm().isSetResponseDocument()) {
            this.execute.getExecute().getResponseForm().addNewResponseDocument();
        }
        for (DocumentOutputDefinitionType documentOutputDefinitionType : this.execute.getExecute().getResponseForm().getResponseDocument().getOutputArray()) {
            if (!documentOutputDefinitionType.getIdentifier().getStringValue().equals(outputName)) continue;
            outputDef = documentOutputDefinitionType;
            break;
        }
        if (outputDef == null) {
            outputDef = this.execute.getExecute().getResponseForm().getResponseDocument().addNewOutput();
        }
        for (DocumentOutputDefinitionType documentOutputDefinitionType : this.processDesc.getProcessOutputs().getOutputArray()) {
            if (!documentOutputDefinitionType.getIdentifier().getStringValue().equals(outputName)) continue;
            outputDef.setAsReference(asReference);
        }
        return true;
    }

    public boolean setStatus(String outputName, boolean status) {
        ResponseFormType responseForm;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!(responseForm = this.execute.getExecute().getResponseForm()).isSetResponseDocument()) {
            responseForm.addNewResponseDocument();
        }
        ResponseDocumentType responseDocument = responseForm.getResponseDocument();
        responseDocument.setStatus(status);
        return true;
    }

    public boolean setSchemaForOutput(String schema, String outputName) {
        String defaultSchema;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!this.execute.getExecute().getResponseForm().isSetResponseDocument()) {
            this.execute.getExecute().getResponseForm().addNewResponseDocument();
        }
        OutputDescriptionType outputDesc = this.getOutputDescription(outputName);
        DocumentOutputDefinitionType outputDef = this.getOutputDefinition(outputName);
        if (outputDef == null) {
            outputDef = this.execute.getExecute().getResponseForm().getResponseDocument().addNewOutput();
            outputDef.setIdentifier(outputDesc.getIdentifier());
        }
        if ((defaultSchema = outputDesc.getComplexOutput().getDefault().getFormat().getSchema()) != null && defaultSchema.equals(schema) || defaultSchema == null && schema == null) {
            outputDef.setSchema(schema);
            return true;
        }
        for (ComplexDataDescriptionType data : outputDesc.getComplexOutput().getSupported().getFormatArray()) {
            if (data.getSchema() != null && data.getSchema().equals(schema)) {
                outputDef.setSchema(schema);
                return true;
            }
            if (data.getSchema() != null || schema != null) continue;
            return true;
        }
        return false;
    }

    public boolean setMimeTypeForOutput(String mimeType, String outputName) {
        String defaultMimeType;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!this.execute.getExecute().getResponseForm().isSetResponseDocument()) {
            this.execute.getExecute().getResponseForm().addNewResponseDocument();
        }
        OutputDescriptionType outputDesc = this.getOutputDescription(outputName);
        DocumentOutputDefinitionType outputDef = this.getOutputDefinition(outputName);
        if (outputDef == null) {
            outputDef = this.execute.getExecute().getResponseForm().getResponseDocument().addNewOutput();
            outputDef.setIdentifier(outputDesc.getIdentifier());
        }
        if ((defaultMimeType = outputDesc.getComplexOutput().getDefault().getFormat().getMimeType()) == null) {
            defaultMimeType = "text/xml";
        }
        if (defaultMimeType.equals(mimeType)) {
            return true;
        }
        for (ComplexDataDescriptionType data : outputDesc.getComplexOutput().getSupported().getFormatArray()) {
            String m = data.getMimeType();
            if (m == null || !m.equals(mimeType)) continue;
            outputDef.setMimeType(mimeType);
            return true;
        }
        return false;
    }

    public boolean setEncodingForOutput(String encoding, String outputName) {
        ComplexDataDescriptionType[] supportedFormats;
        String defaultEncoding;
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!this.execute.getExecute().getResponseForm().isSetResponseDocument()) {
            this.execute.getExecute().getResponseForm().addNewResponseDocument();
        }
        OutputDescriptionType outputDesc = this.getOutputDescription(outputName);
        DocumentOutputDefinitionType outputDef = this.getOutputDefinition(outputName);
        if (outputDef == null) {
            outputDef = this.execute.getExecute().getResponseForm().getResponseDocument().addNewOutput();
            outputDef.setIdentifier(outputDesc.getIdentifier());
        }
        if ((defaultEncoding = outputDesc.getComplexOutput().getDefault().getFormat().getEncoding()) == null) {
            defaultEncoding = "UTF-8";
        }
        if (defaultEncoding.equals(encoding)) {
            return true;
        }
        for (ComplexDataDescriptionType data : supportedFormats = outputDesc.getComplexOutput().getSupported().getFormatArray()) {
            String e = data.getEncoding();
            if (e == null || !e.equals(encoding)) continue;
            outputDef.setEncoding(encoding);
            return true;
        }
        return false;
    }

    private OutputDescriptionType getOutputDescription(String outputName) {
        for (OutputDescriptionType outputDesc : this.processDesc.getProcessOutputs().getOutputArray()) {
            if (!outputDesc.getIdentifier().getStringValue().equals(outputName)) continue;
            return outputDesc;
        }
        return null;
    }

    private DocumentOutputDefinitionType getOutputDefinition(String outputName) {
        DocumentOutputDefinitionType[] outputs;
        for (DocumentOutputDefinitionType outputDef : outputs = this.execute.getExecute().getResponseForm().getResponseDocument().getOutputArray()) {
            if (!outputDef.getIdentifier().getStringValue().equals(outputName)) continue;
            return outputDef;
        }
        return null;
    }

    public boolean setResponseDocument(String outputIdentifier, String schema, String encoding, String mimeType) {
        if (!this.execute.getExecute().isSetResponseForm()) {
            this.execute.getExecute().addNewResponseForm();
        }
        if (!this.execute.getExecute().getResponseForm().isSetResponseDocument()) {
            this.execute.getExecute().getResponseForm().addNewResponseDocument();
        }
        OutputDescriptionType outputDesc = this.getOutputDescription(outputIdentifier);
        DocumentOutputDefinitionType outputDef = this.getOutputDefinition(outputIdentifier);
        if (outputDef == null) {
            outputDef = this.execute.getExecute().getResponseForm().getResponseDocument().addNewOutput();
            outputDef.setIdentifier(outputDesc.getIdentifier());
            if (schema != null) {
                outputDef.setSchema(schema);
            }
            if (encoding != null) {
                outputDef.setEncoding(encoding);
            }
            if (mimeType != null) {
                outputDef.setMimeType(mimeType);
            }
        }
        return false;
    }

    public boolean setRawData(String outputIdentifier, String schema, String encoding, String mimeType) {
        OutputDefinitionType output = this.execute.getExecute().addNewResponseForm().addNewRawDataOutput();
        output.addNewIdentifier().setStringValue(outputIdentifier);
        if (schema != null) {
            output.setSchema(schema);
        }
        if (mimeType != null) {
            output.setMimeType(mimeType);
        }
        if (encoding != null) {
            output.setEncoding(encoding);
        }
        return true;
    }

    public ExecuteDocument getExecute() {
        return this.execute;
    }

    public String getExecuteAsGETString() throws UnsupportedEncodingException {
        String request = "?service=wps&request=execute&version=1.0.0&identifier=";
        request = request + this.processDesc.getIdentifier().getStringValue();
        request = request + "&DataInputs=";
        InputType[] inputs = this.execute.getExecute().getDataInputs().getInputArray();
        int inputCounter = 0;
        for (InputType input : inputs) {
            request = request + input.getIdentifier().getStringValue();
            if (input.isSetReference()) {
                InputReferenceType reference = input.getReference();
                request = request + "=" + "@xlink:href=" + URLEncoder.encode(reference.getHref(), "UTF-8");
                if (reference.isSetEncoding()) {
                    request = request + "@encoding=" + reference.getEncoding();
                }
                if (reference.isSetMimeType()) {
                    request = request + "@format=" + reference.getMimeType();
                }
                if (reference.isSetEncoding()) {
                    request = request + "@schema=" + reference.getSchema();
                }
            }
            if (input.isSetData()) {
                if (input.getData().isSetComplexData()) {
                    ComplexDataType complexData = input.getData().getComplexData();
                    request = request + "=" + URLEncoder.encode(input.getData().getComplexData().xmlText(), "UTF-8");
                    if (complexData.isSetEncoding()) {
                        request = request + "@encoding=" + complexData.getEncoding();
                    }
                    if (complexData.isSetMimeType()) {
                        request = request + "@format=" + complexData.getMimeType();
                    }
                    if (complexData.isSetEncoding()) {
                        request = request + "@schema=" + complexData.getSchema();
                    }
                }
                if (input.getData().isSetLiteralData()) {
                    LiteralDataType literalData = input.getData().getLiteralData();
                    request = request + "=" + literalData.getStringValue();
                    if (literalData.isSetDataType()) {
                        request = request + "@datatype=" + literalData.getDataType();
                    }
                    if (literalData.isSetUom()) {
                        request = request + "@datatype=" + literalData.getUom();
                    }
                }
            }
            if (++inputCounter >= inputs.length) continue;
            request = request + ";";
        }
        if (this.execute.getExecute().getResponseForm().getResponseDocument() == null) {
            throw new RuntimeException("ResponseDocument missing");
        }
        DocumentOutputDefinitionType[] outputs = this.execute.getExecute().getResponseForm().getResponseDocument().getOutputArray();
        int outputCounter = 0;
        request = this.execute.getExecute().getResponseForm().isSetRawDataOutput() ? request + "&rawdataoutput=" : request + "&responsedocument=";
        for (DocumentOutputDefinitionType output : outputs) {
            request = request + output.getIdentifier().getStringValue();
            if (output.isSetEncoding()) {
                request = request + "@encoding=" + output.getEncoding();
            }
            if (output.isSetMimeType()) {
                request = request + "@format=" + output.getMimeType();
            }
            if (output.isSetEncoding()) {
                request = request + "@schema=" + output.getSchema();
            }
            if (output.isSetUom()) {
                request = request + "@datatype=" + output.getUom();
            }
            if (++outputCounter >= outputs.length) continue;
            request = request + ";";
        }
        if (this.execute.getExecute().getResponseForm().getResponseDocument().isSetStoreExecuteResponse()) {
            request = request + "&storeExecuteResponse=true";
        }
        if (this.execute.getExecute().getResponseForm().getResponseDocument().isSetStatus()) {
            request = request + "&status=true";
        }
        if (this.execute.getExecute().getResponseForm().getResponseDocument().isSetLineage()) {
            request = request + "&lineage=true";
        }
        return request;
    }

    private InputDescriptionType getParameterDescription(String id) {
        InputDescriptionType[] inputDescs;
        for (InputDescriptionType inputDesc : inputDescs = this.processDesc.getDataInputs().getInputArray()) {
            if (!inputDesc.getIdentifier().getStringValue().equals(id)) continue;
            return inputDesc;
        }
        return null;
    }
}

