/*
 * Decompiled with CFR 0.152.
 */
package cobweb.m24;

import cobweb.m24.GenericWorkItemHandlerClient;
import cobweb.m24.GenericWorkItemHandlerConflationClient;
import cobweb.m24.StoreWFSWorkItemHandlerClient;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.test.JBPMHelper;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;

public class BiologicalMonitoringTest {
    public static void main(String[] args) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kContainer = ks.getKieClasspathContainer();
        KieSession ksession = kContainer.newKieSession("ksession-process");
        ksession.getWorkItemManager().registerWorkItemHandler("Pillar 2 - Attribute Range Check", (WorkItemHandler)new GenericWorkItemHandlerClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Store results in WFS-T", (WorkItemHandler)new StoreWFSWorkItemHandlerClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Pillar 1 - Get Spatial Accuracy", (WorkItemHandler)new GenericWorkItemHandlerClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Pillar 6 - Count Tweets with location", (WorkItemHandler)new GenericWorkItemHandlerClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Conflation - Geometry Distance", (WorkItemHandler)new GenericWorkItemHandlerConflationClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Pillar 2 - Filter on attribute", (WorkItemHandler)new GenericWorkItemHandlerClient());
        ksession.getWorkItemManager().registerWorkItemHandler("Pillar 4 - Point In Polygon", (WorkItemHandler)new GenericWorkItemHandlerClient());
        String wpsURL = "http://localhost:8010/wps/WebProcessingService?";
        String processId = "pillar.cleaning.FilterOnAttribute";
        String catalogURL = "http://localhost:8010/geonetwork";
        String inputObservations = "https://dyfi.cobwebproject.eu/geoserver/cobweb/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=cobweb:sid-anonsurvey&maxFeatures=50&outputFormat=text/xml;%20subtype=gml/3.1.1";
        String fieldName = "Species";
        String featureName = "Hazel";
        String include = "true";
        HashMap<String, String> wpsInputs = new HashMap<String, String>();
        wpsInputs.put("inputObservations", inputObservations);
        wpsInputs.put("fieldName", fieldName);
        wpsInputs.put("featureName", featureName);
        wpsInputs.put("include", include);
        HashMap<String, String> wpsPolygonInputs = new HashMap<String, String>();
        String inputAuthoritativeData = "http://grasp.nottingham.ac.uk:8010/geoserver/CobwebTest/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=CobwebTest:Dyfi_Bio_Selection&outputFormat=gml3";
        wpsPolygonInputs.put("inputAuthoritativeData", inputAuthoritativeData);
        wpsPolygonInputs.put("inputObservations", inputObservations);
        HashMap<String, String> wpsAttributeInputs = new HashMap<String, String>();
        wpsAttributeInputs.put("attributeName", "pos_acc");
        wpsAttributeInputs.put("minRange", "30");
        wpsAttributeInputs.put("maxRange", "100");
        HashMap<String, String> wpsGetSpatialInputs = new HashMap<String, String>();
        wpsGetSpatialInputs.put("inputSatelliteNumberField", "pos_sat");
        wpsGetSpatialInputs.put("inputAccuracyField", "pos_acc");
        wpsGetSpatialInputs.put("minSatNum", "0");
        wpsGetSpatialInputs.put("minAcc", "0");
        HashMap<String, String> wpsTwitter = new HashMap<String, String>();
        wpsTwitter.put("inputLocation", "52.56585, -3.82793");
        wpsTwitter.put("inputDistance", "1000");
        wpsTwitter.put("searchTerm", "#Hazel");
        wpsTwitter.put("dateSince", "2014-11-18");
        String conflationWPS = "http://cobweb.gis.geo.tu-dresden.de:8080/wps_conflation/WebProcessingService?";
        String confProcID = "de.tudresden.gis.fusion.algorithm.GeometryDistance";
        HashMap<String, String> conflationHash = new HashMap<String, String>();
        String inputConflationData = "http://grasp.nottingham.ac.uk:8010/geoserver/CobwebTest/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=CobwebTest:Dyfi_Bio_Selection&maxFeatures=50&outputFormat=gml3";
        conflationHash.put("IN_TARGET", inputConflationData);
        conflationHash.put("IN_REFERENCE", inputAuthoritativeData);
        conflationHash.put("IN_THRESHOLD", "0");
        HashMap<String, HashMap<String, String>> params = new HashMap<String, HashMap<String, String>>();
        params.put("pointInPolygonMap", wpsPolygonInputs);
        params.put("filterOnAttributeMap", wpsInputs);
        params.put("getSpatialAccuracyMap", wpsGetSpatialInputs);
        params.put("attributeRangeCheckMap", wpsAttributeInputs);
        params.put("countTweetsWithLocationMap", wpsTwitter);
        params.put("geometryConflationMap", conflationHash);
        ksession.startProcess("cobweb.m24.biologicalmonitoring", params);
    }

    private static RuntimeManager createRuntimeManager(KieBase kbase) {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).knowledgeBase(kbase);
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(builder.get(), "cobweb.m24:example:1.0");
    }
}

