/*
 * Decompiled with CFR 0.152.
 */
package clients.test;

import cobweb.m24.ExecuteRequestBuilder;
import cobweb.m24.ExecuteResponseAnalyser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.DataType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.opengis.feature.simple.SimpleFeature;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class TestClient {
    public void testExecute() {
        String wpsURL = "http://cobweb.gis.geo.tu-dresden.de:8080/wps_conflation/WebProcessingService?";
        String processID = "de.tudresden.gis.fusion.algorithm.GeometryDistance";
        try {
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            System.out.println(describeProcessDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            CapabilitiesDocument capabilitiesDocument = this.requestGetCapabilities(wpsURL);
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            ProcessDescriptionType.DataInputs di = describeProcessDocument.getDataInputs();
            GenericFileData inputMetFile = new GenericFileData(new File("/Users/lgzsam/Documents/Projects/GRASP/Apsim_Examples/Examples/MetFiles/Dalby.met"), "text/plain");
            GenericFileData inputFile = new GenericFileData(new File("/Users/lgzsam/Documents/Projects/GRASP/Apsim_Examples/Examples/Canopy1.apsim"), "text/xml");
            String sampleDataURL = "http://localhost:8010/geoserver/cobweb/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=cobweb:SampleData&outputFormat=gml3";
            inputs.put("IN_TARGET", "http://grasp.nottingham.ac.uk:8010/geoserver/CobwebTest/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=CobwebTest:SampleData&outputFormat=gml3&srs=EPSG:4326");
            inputs.put("IN_REFERENCE", "http://grasp.nottingham.ac.uk:8010/geoserver/CobwebTest/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=CobwebTest:Dyfi_Bio_Selection&outputFormat=gml3&srs=EPSG:4326");
            inputs.put("IN_THRESHOLD", "1");
            Object[] data = new Object[3];
            data = this.executeProcess(wpsURL, processID, describeProcessDocument, inputs);
            if (data[0] instanceof LiteralIntBinding) {
                int i = ((LiteralIntBinding)data[0]).getPayload();
                System.out.println(data[0]);
            }
            if (data[0] instanceof GTVectorDataBinding) {
                FeatureCollection featureCollection = ((GTVectorDataBinding)data[0]).getPayload();
                SimpleFeatureIterator sf = (SimpleFeatureIterator)featureCollection.features();
                System.out.println(featureCollection.size());
                while (sf.hasNext()) {
                    System.out.println(((SimpleFeature)sf.next()).toString());
                }
            } else {
                System.out.println("NOT GTVECTORDATABINDING");
            }
            if (data[0] instanceof GenericFileDataBinding) {
                GenericFileData xmlGenericData = ((GenericFileDataBinding)data[0]).getPayload();
                File file = xmlGenericData.getBaseFile(true);
                FileInputStream fis = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                File newFile = File.createTempFile("temp2", ".out");
                FileWriter fw = new FileWriter(newFile);
                String line = br.readLine();
                while (line != null) {
                    String newLine = line.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&");
                    System.out.println(newLine);
                    fw.write(newLine);
                    line = br.readLine();
                }
                fw.close();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document tempXML = builder.newDocument();
                tempXML = builder.parse(newFile);
                NodeList list = tempXML.getElementsByTagName("xs:element");
                System.out.println("LIST LENGTH " + list.getLength());
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        ProcessBriefType[] processList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        System.out.println(capabilities.toString());
        for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
            System.out.println(process.getIdentifier().getStringValue());
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        InputDescriptionType[] inputList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        for (InputDescriptionType input : inputList = processDescription.getDataInputs().getInputArray()) {
            System.out.println(input.getIdentifier().getStringValue());
        }
        return processDescription;
    }

    public Object[] executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, Object> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String inputName = input.getIdentifier().getStringValue();
            Object inputValue = inputs.get(inputName);
            if (input.getLiteralData() != null) {
                if (!(inputValue instanceof String)) continue;
                executeBuilder.addLiteralData(inputName, (String)inputValue);
                continue;
            }
            if (input.getComplexData() == null) continue;
            if (inputValue instanceof FeatureCollection) {
                GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", null, "text/xml; subtype=gml/3.1.0");
            }
            if (inputValue instanceof String) {
                executeBuilder.addComplexDataReference(inputName, (String)inputValue, "http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", null, "text/xml; subtype=gml/3.1.0");
            }
            if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
            throw new IOException("Property not set, but mandatory: " + inputName);
        }
        executeBuilder.setMimeTypeForOutput("text/xml; subtype=gml/3.1.0", "OUT_TARGET");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.0/base/feature.xsd", "OUT_TARGET");
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            DataType dataType = response.getExecuteResponse().getProcessOutputs().getOutputArray(0).getData();
            Object[] dataReturn = new Object[3];
            IData data = analyser.getComplexData("OUT_TARGET", GTVectorDataBinding.class);
            System.out.println(dataType.toString());
            dataReturn[0] = (GTVectorDataBinding)data;
            return dataReturn;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public static void main(String[] args) {
        TestClient client = new TestClient();
        client.testExecute();
    }
}

