package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * parses the response from querying yahoo placefinder 
 * provides methods for extracting relevant information 
 * 
 * example yahoo output:
 * 
 <?xml version="1.0" encoding="UTF-8"?>
 <ResultSet version="1.0">
 <Error>0</Error>
 <ErrorMessage>No error</ErrorMessage>
 <Locale>us_US</Locale>
 <Quality>0</Quality>
 <Found>1</Found>
 <Result>
 <quality>60</quality>
 <latitude>37.422676</latitude>
 <longitude>-121.817600</longitude>
 <offsetlat>37.422668</offsetlat>
 <offsetlon>-121.745209</offsetlon>
 <radius>12900</radius>
 <name></name>
 <line1></line1>
 <line2>Milpitas, CA  95035</line2>
 <line3></line3>
 <line4>United States</line4>
 <house></house>
 <street></street>
 <xstreet></xstreet>
 <unittype></unittype>
 <unit></unit>
 <postal>95035</postal>
 <neighborhood></neighborhood>
 <city>Milpitas</city>
 <county>Santa Clara County</county>
 <state>California</state>
 <country>United States</country>
 <countrycode>US</countrycode>
 <statecode>CA</statecode>
 <countycode></countycode>
 <uzip>95035</uzip>
 <hash></hash>
 <woeid>12797523</woeid>
 <woetype>11</woetype>
 </Result>
 </ResultSet>
 <!-- gws13.maps.ch1.yahoo.com uncompressed/chunked Wed Mar  2 12:54:12 PST 2011 -->
 */
class YahooXMLResponseParser {

	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
	/*
	 * store each attribute from the xml file in a variable
	 */
	private String quality = "?";
	private String latitude = "?";
	private String longitude = "?";
	private String offsetlat = "?";
	private String offsetlon = "?";
	private String radius = "?";
	private String name = "?";
	private String line1 = "?";
	private String line2 = "?";
	private String line3 = "?";
	private String line4 = "?";
	private String house = "?";
	private String street = "?";
	private String xstreet = "?";
	private String unittype = "?";
	private String unit = "?";
	private String postal = "?";
	private String neighborhood = "?";
	private String city = "?";
	private String county = "?";
	private String state = "?";
	private String country = "?";
	private String countrycode = "?";
	private String statecode = "?";
	private String countycode = "?";
	private String uzip = "?";
	private String hash = "?";
	private String woeid = "?";
	private String woetype = "?";

	private String XML="";
	private String placeName="";

	/*
	 * TODO: use other parser and remove this
	 */
	protected YahooXMLResponseParser(String YahooResponse) {
		this.XML = YahooResponse;
	}

	//sets variables to '?' where no info is present
	protected void parseXML() {

//		logger.info("XML: "+XML);

		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(XML));

			Document doc = db.parse(is);

			//parent node
			NodeList nodes = doc.getElementsByTagName("Result");
			nodes = doc.getChildNodes();

			// iterate the results
			// there will most likely only be one.
			//we use -1 to ignore resultset element
			for (int i = 0; i < nodes.getLength()-1; i++) {

				if(nodes.item(i).getNodeType()== Node.COMMENT_NODE){ //yahoo have added a comment to the end of their response - this will ignore it
//					logger.info("messing up on... " +nodes.item(i));
					break;
				}
				Element element = (Element) nodes.item(i);
//				logger.info("Element " + i + " : " + element.getNodeName());
//				logger.info("number of children: " +element.getChildNodes().getLength());

				NodeList qualityNode = element.getElementsByTagName("quality");
				Element line = (Element) qualityNode.item(0);
				if(line!=null){										//check to make sure this information exists to avoid null pointer exception
					quality = getCharacterDataFromElement(line);
					//				logger.info("Quality: "+quality );
				}

				NodeList latitudeNode = element.getElementsByTagName("latitude");
				line = (Element) latitudeNode.item(0);
				if(line!=null){
					latitude = getCharacterDataFromElement(line);
					//				logger.info("Latitude: "+latitude);
				}

				NodeList longitudeNode = element.getElementsByTagName("longitude");
				line = (Element) longitudeNode.item(0);
				if(line!=null){
					longitude = getCharacterDataFromElement(line);
					//				logger.info("Longitude: "+longitude);
				}

				NodeList offsetlatNode = element.getElementsByTagName("offsetlat");
				line = (Element) offsetlatNode.item(0);
				if(line!=null){
					offsetlat = getCharacterDataFromElement(line);
					//				logger.info("offsetlat: "+offsetlat);
				}

				NodeList offsetlonNode = element.getElementsByTagName("offsetlon");
				line = (Element) offsetlonNode.item(0);
				if(line!=null){
					offsetlon = getCharacterDataFromElement(line);
					//				logger.info("offsetlon: "+offsetlon);
				}

				NodeList radiusNode = element.getElementsByTagName("radius");
				line = (Element) radiusNode.item(0);
				if(line!=null){
					radius = getCharacterDataFromElement(line);
					//				logger.info("radius: "+radius);
				}

				NodeList nameNode = element.getElementsByTagName("name");
				line = (Element) nameNode.item(0);
				if(line!=null){
					name = getCharacterDataFromElement(line);
					//				logger.info("name: "+name);
				}

				NodeList line1Node = element.getElementsByTagName("line1");
				line = (Element) line1Node.item(0);
				if(line!=null){
					line1 = getCharacterDataFromElement(line);
					//				logger.info("line1: "+line1);
				}

				NodeList line2Node = element.getElementsByTagName("line2");
				line = (Element) line2Node.item(0);
				if(line!=null){
					line2 = getCharacterDataFromElement(line);
					//				logger.info("line2: "+line2);
				}

				NodeList line3Node = element.getElementsByTagName("line3");
				line = (Element) line3Node.item(0);
				if(line!=null){
					line3 = getCharacterDataFromElement(line);
					//				logger.info("line3: "+line3);
				}

				NodeList line4Node = element.getElementsByTagName("line4");
				line = (Element) line4Node.item(0);
				if(line!=null){
					line4 = getCharacterDataFromElement(line);
					//				logger.info("line4: "+line4);
				}

				NodeList houseNode = element.getElementsByTagName("house");
				line = (Element) houseNode.item(0);
				if(line!=null){
					house = getCharacterDataFromElement(line);
					//				logger.info("house: "+house);
				}

				NodeList streetNode = element.getElementsByTagName("street");
				line = (Element) streetNode.item(0);
				if(line!=null){
					street = getCharacterDataFromElement(line);
					//				logger.info("street: "+street);
				}

				NodeList xstreetNode = element.getElementsByTagName("xstreet");
				line = (Element) xstreetNode.item(0);
				if(line!=null){
					xstreet = getCharacterDataFromElement(line);
					//				logger.info("xstreet: "+xstreet);
				}

				NodeList unittypeNode = element.getElementsByTagName("unittype");
				line = (Element) unittypeNode.item(0);
				if(line!=null){
					unittype = getCharacterDataFromElement(line);
					//				logger.info("unittype: "+unittype);
				}

				NodeList unitNode = element.getElementsByTagName("unit");
				line = (Element) unitNode.item(0);
				if(line!=null){
					unit = getCharacterDataFromElement(line);
					//				logger.info("unit: "+unit);
				}

				NodeList postalNode = element.getElementsByTagName("postal");
				line = (Element) postalNode.item(0);
				if(line!=null){
					postal = getCharacterDataFromElement(line);
					//				logger.info("postal: "+postal);
				}

				NodeList neighborhoodNode = element.getElementsByTagName("neighborhood");
				line = (Element) neighborhoodNode.item(0);
				if(line!=null){
					neighborhood = getCharacterDataFromElement(line);
					//				logger.info("neighborhood: "+neighborhood);
				}

				NodeList cityNode = element.getElementsByTagName("city");
				line = (Element) cityNode.item(0);
				if(line!=null){
					city = getCharacterDataFromElement(line);
					//				logger.info("city: "+city);
				}

				NodeList countyNode = element.getElementsByTagName("county");
				line = (Element) countyNode.item(0);
				if(line!=null){
					county = getCharacterDataFromElement(line);
					//				logger.info("county: "+county);
				}

				NodeList stateNode = element.getElementsByTagName("state");
				line = (Element) stateNode.item(0);
				if(line!=null){
					state = getCharacterDataFromElement(line);
					//				logger.info("state: "+state);
				}

				NodeList countryNode = element.getElementsByTagName("country");
				line = (Element) countryNode.item(0);
				if(line!=null){
					country = getCharacterDataFromElement(line);
					//				logger.info("country: "+country);
				}

				NodeList countrycodeNode = element.getElementsByTagName("countrycode");
				line = (Element) countrycodeNode.item(0);
				if(line!=null){
					countrycode = getCharacterDataFromElement(line);
					//				logger.info("countrycode: "+countrycode);
				}

				NodeList statecodeNode = element.getElementsByTagName("statecode");
				line = (Element) statecodeNode.item(0);
				if(line!=null){
					statecode = getCharacterDataFromElement(line);
					//				logger.info("statecode: "+statecode);
				}

				NodeList countycodeNode = element.getElementsByTagName("countycode");
				line = (Element) countycodeNode.item(0);
				if(line!=null){
					countycode = getCharacterDataFromElement(line);
					//				logger.info("countycode: "+countycode);
				}

				NodeList uzipNode = element.getElementsByTagName("uzip");			
				line = (Element) uzipNode.item(0);
				if(line!=null){
					uzip = getCharacterDataFromElement(line);
					//				logger.info("uzip: "+uzip);
				}

				NodeList hashNode = element.getElementsByTagName("hash");
				line = (Element) hashNode.item(0);
				if(line!=null){
					hash = getCharacterDataFromElement(line);
					//				logger.info("hash: "+hash);
				}

				NodeList woeidNode = element.getElementsByTagName("woeid");
				line = (Element) woeidNode.item(0);
				if(line!=null){
					woeid = getCharacterDataFromElement(line);
					//				logger.info("woeid: "+woeid);
				}

				NodeList woetypeNode = element.getElementsByTagName("woetype");
				line = (Element) woetypeNode.item(0);
				if(line!=null){
					woetype = getCharacterDataFromElement(line);
					//				logger.info("woetype: "+woetype);
				}


			}

		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		concatenatePlaceName();
	}

	//retrieve attribute value
	private String getCharacterDataFromElement(Element e) {
		Node child = e.getFirstChild();
		if (child instanceof CharacterData) {
			CharacterData cd = (CharacterData) child;
			return cd.getData();
		}
		return "?";
	}

	/*
	 * TODO: check the format of placenames ... i.e., the order of concatenation
	 */
	private String concatenatePlaceName(){
		//		logger.info("Concatenating placename");
		placeName = "";
		if(name != "?"){
			placeName += name+" ";
		}
		if(line1 != "?"){
			placeName += line1+" ";
		}
		if(line2 != "?"){
			placeName += line2+" ";
		}
		if(line3 != "?"){
			placeName += line3+" ";
		}
		if(line4 != "?"){
			placeName += line4+" ";
		}
		if(house != "?"){
			placeName +=house+" ";
		}
		if(street != "?"){
			placeName += street+" ";
		}
		if(xstreet != "?"){
			placeName += xstreet+" ";
		}if(postal != "?"){
			placeName += postal+" ";
		}if(neighborhood != "?"){
			placeName += neighborhood+" ";
		}if(city != "?"){
			placeName += city+" ";
		}if(county != "?"){
			placeName += county+" ";
		}if(state != "?"){
			placeName += state+" ";
		}if(country != "?"){
			placeName += country+" ";
		}
		//		logger.info("PLACENAME "+placeName);
		return placeName;

	}

	protected String getQuality() {
		return quality;
	}

	protected String getLatitude() {
		return latitude;
	}

	protected String getLongitude() {
		return longitude;
	}

	protected String getOffsetlat() {
		return offsetlat;
	}

	protected String getOffsetlon() {
		return offsetlon;
	}

	protected String getRadius() {
		return radius;
	}

	protected String getName() {
		return name;
	}

	protected String getLine1() {
		return line1;
	}

	protected String getLine2() {
		return line2;
	}

	protected String getLine3() {
		return line3;
	}

	protected String getLine4() {
		return line4;
	}

	protected String getHouse() {
		return house;
	}

	protected String getStreet() {
		return street;
	}

	protected String getXstreet() {
		return xstreet;
	}

	protected String getUnittype() {
		return unittype;
	}

	protected String getUnit() {
		return unit;
	}

	protected String getPostal() {
		return postal;
	}

	protected String getNeighborhood() {
		return neighborhood;
	}

	protected String getCity() {
		return city;
	}

	protected String getCounty() {
		return county;
	}

	protected String getState() {
		return state;
	}

	protected String getCountry() {
		return country;
	}

	protected String getCountrycode() {
		return countrycode;
	}

	protected String getStatecode() {
		return statecode;
	}

	protected String getCountycode() {
		return countycode;
	}

	protected String getUzip() {
		return uzip;
	}

	protected String getHash() {
		return hash;
	}

	public String getWoeid() {
		return woeid;
	}

	protected String getWoetype() {
		return woetype;
	}

	protected String getPlaceName() {
		return placeName;
	}

	/*
	 * just for testing
	 */
//	public static void main(String[] args) {
//
//		YahooXMLResponseParser test = new YahooXMLResponseParser(
//		"<?xml version=\"1.0\" encoding=\"UTF-8\"?><ResultSet version=\"1.0\"><Error>0</Error><ErrorMessage>No error</ErrorMessage><Locale>us_US</Locale><Quality>0</Quality><Found>1</Found><Result><quality>60</quality><latitude>37.422676</latitude><longitude>-121.817600</longitude><offsetlat>37.422668</offsetlat><offsetlon>-121.745209</offsetlon><radius>12900</radius><name></name><line1></line1><line2>Milpitas, CA  95035</line2><line3></line3><line4>United States</line4><house></house><street></street><xstreet></xstreet><unittype></unittype><unit></unit><postal>95035</postal><neighborhood></neighborhood><city>Milpitas</city><county>Santa Clara County</county><state>California</state><country>United States</country><countrycode>US</countrycode><statecode>CA</statecode><countycode></countycode><uzip>95035</uzip><hash></hash><woeid>12797523</woeid><woetype>11</woetype></Result></ResultSet><!-- gws13.maps.ch1.yahoo.com uncompressed/chunked Wed Mar  2 12:54:12 PST 2011 -->");
//
//
//		YahooXMLResponseParser testExtendedResponse = new YahooXMLResponseParser("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ResultSet version=\"1.0\"><Error>0</Error><ErrorMessage>No error</ErrorMessage><Locale>us_US</Locale><Quality>40</Quality><Found>1</Found><Result><quality>40</quality><latitude>53.348070</latitude><longitude>-6.248274</longitude><offsetlat>53.348070</offsetlat><offsetlon>-6.248274</offsetlon><radius>25900</radius><name></name><line1></line1><line2>DUBLIN, COUNTY DUBLIN</line2><line3></line3><line4>IRELAND</line4><house></house><street></street><xstreet></xstreet><unittype></unittype><unit></unit><postal></postal><neighborhood></neighborhood><city>Dublin</city><county>County Dublin</county><state></state><country>Ireland</country><countrycode>IE</countrycode><statecode></statecode><countycode></countycode><uzip>1</uzip><hash></hash><woeid>560743</woeid><woetype>7</woetype></Result></ResultSet><!-- gws13.maps.ch1.yahoo.com uncompressed/chunked Thu Sep  1 05:57:54 PDT 2011 --><!-- wws2.geotech.ch1.yahoo.com uncompressed/chunked Thu Sep  1 05:57:54 PDT 2011 -->");
//
//		test.parseXML();
//		logger.info(test.getPlaceName());
//
//		logger.info();
//
//		testExtendedResponse.parseXML();
//		logger.info(testExtendedResponse.getPlaceName());
//
//	}

}
