package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * parses the response from querying yahoo geoplanet
 * provides methods for extracting relevant information 
 * 
 * example yahoo output:
 * 
 <?xml version="1.0" encoding="UTF-8"?>  
 <places xmlns="http://where.yahooapis.com/v1/schema.rng" xmlns:yahoo="http://www.yahooapis.com/v1/base.rng" yahoo:start="0" yahoo:count="1" yahoo:total="1">  
 <place yahoo:uri="http://where.yahooapis.com/v1/place/12521721" xml:lang="en-us">  
 <woeid>12521721</woeid>  
 <placeTypeName code="14">Airport</placeTypeName>  
 <name>San Francisco International Airport</name>  
 <country type="Country" code="US">United States</country>  
 <admin1 type="State" code="US-CA">California</admin1>  
 <admin2 type="County" code="">San Mateo</admin2>  
 <admin3></admin3>  
 <locality1>Millbrae</locality1>  
 <locality2></locality2>  
 <postal type="Zip Code">94128</postal>  
 <centroid>  
 <latitude>37.614712</latitude>  
 <longitude>-122.391808</longitude>  
 </centroid>  
 <boundingBox>  
 <southWest>  
 <latitude>37.601822</latitude>  
 <longitude>-122.408089</longitude>  
 </southWest>  
 <northEast>  
 <latitude>37.627602</latitude>  
 <longitude>-122.375526</longitude>  
 </northEast>  
 </boundingBox>  
 </place>  
 </places>  
 */
class YahooGeoplanetXMLResponseParser {
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
	/*
	 * store each attribute from the xml file in a variable
	 */
	private String woeid = "";
	private String placeTypeName = "";
	private String placeTypeNameCode = "";
	private String name = "";
	private String countryType = "";
	private String countryCode = "";
	private String countryName = "";
	private String admin1Type = "";
	private String admin1Code = "";
	private String admin1Name = "";
	private String admin2Type = "";
	private String admin2Code = "";
	private String admin2Name = "";
	private String admin3Type = "";
	private String admin3Code = "";
	private String admin3Name = "";
	private String locality1 = "";
	private String locality2 = "";
	private String postalType = "";
	private String postalCode = "";
	private double[] centroid = null; //new double[2]; // stores long/lat of centroid
	private double[][] boundingBox; // stores long/lat of southwest/northeast
									// bounding box

	private String XML;

	/*
	 * constructor takes in a xml string to be parsed
	 */
	public YahooGeoplanetXMLResponseParser(String YahooResponse) {
		this.XML = YahooResponse;
	}

	/*
	 * retrieve relevant information from xml and store in relevant variables
	 */
	public void parseXML() {
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(XML));

			Document doc = db.parse(is);

			// parent node
			NodeList nodes = doc.getElementsByTagName("place");
			if (nodes != null) {
				if (nodes.getLength() > 0) {
					nodes = nodes.item(0).getChildNodes();
					for (int i = 0; i < nodes.getLength(); i++) {
						Element element = (Element) nodes.item(i);
						// logger.info("element tag name: "
						// +element.getTagName());
						if (element.getTagName() == "woeid") {
							woeid = element.getTextContent();
							// logger.info("WOEID: " +woeid);
						} else if (element.getTagName() == "placeTypeName") {
							placeTypeNameCode = element.getAttribute("code");
							placeTypeName = element.getTextContent();
							// logger.info("Placetypnamecode: "+placeTypeNameCode+" , placetypename: "+placeTypeName);
						} else if (element.getTagName() == "name") {
							name = element.getTextContent();
							// logger.info("name: " +name);
						} else if (element.getTagName() == "country") {
							countryType = element.getAttribute("type");
							countryCode = element.getAttribute("code");
							countryName = element.getTextContent();
							// logger.info("countrytype: "+countryType+", Countrycode: "+countryCode+" , countryname: "+countryName);
						} else if (element.getTagName() == "admin1") {
							admin1Type = element.getAttribute("type");
							admin1Code = element.getAttribute("code");
							admin1Name = element.getTextContent();
							// logger.info("admin1 name: " +admin1Name);
						} else if (element.getTagName() == "admin2") {
							admin2Type = element.getAttribute("type");
							admin2Code = element.getAttribute("code");
							admin2Name = element.getTextContent();
							// logger.info("admin2 name: " +admin2Name);
						} else if (element.getTagName() == "admin3") {
							admin3Type = element.getAttribute("type");
							admin3Code = element.getAttribute("code");
							admin3Name = element.getTextContent();
							// logger.info("admin3 name: " +admin3Name);
						} else if (element.getTagName() == "locality1") {
							locality1 = element.getTextContent();
						} else if (element.getTagName() == "locality2") {
							locality2 = element.getTextContent();
						} else if (element.getTagName() == "postal") {
							postalType = element.getAttribute("type");
							postalCode = element.getTextContent();
						} else if (element.getTagName() == "centroid") {
							NodeList centroidNodes = element.getChildNodes();
							try {
								if (centroid == null) {
									centroid = new double[2];
								}
								centroid[0] = Double.parseDouble(centroidNodes
										.item(0).getTextContent()); // add
																	// latitude
																	// value
								// logger.info("latitude: "
								// +centroid[0]);
								centroid[1] = Double.parseDouble(centroidNodes
										.item(1).getTextContent()); // add
																	// longitude
																	// value
								// logger.info("longitude: "
								// +centroid[1]);
							} catch (NumberFormatException e) {
								System.out
										.println("YahooGeoplanetXmlResponseParser..  could not get centroid");
								centroidNodes = null;
							}
						} else if (element.getTagName() == "boundingBox") {
							NodeList boundingBoxNodes = element.getChildNodes();

							NodeList southWestNodes = boundingBoxNodes.item(0)
									.getChildNodes();
							double southwestLat = Double
									.parseDouble(southWestNodes.item(0)
											.getTextContent());
							double southwestLong = Double
									.parseDouble(southWestNodes.item(1)
											.getTextContent());

							NodeList northEastNodes = boundingBoxNodes.item(1)
									.getChildNodes();
							double northEastLat = Double
									.parseDouble(northEastNodes.item(0)
											.getTextContent());
							double northEastLong = Double
									.parseDouble(northEastNodes.item(1)
											.getTextContent());

							// add coordinates to array
							double[][] boundingBox2 = {
									{ southwestLat, southwestLong },
									{ northEastLat, northEastLong } };
							boundingBox = boundingBox2;
							// logger.info("length of 2D array: "+boundingBox.length);

						}
					}
				}
			}

		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// concatenatePlaceName();
	}

	// retrieve attribute value
	private String getCharacterDataFromElement(Element e) {
		Node child = e.getFirstChild();
		if (child instanceof CharacterData) {
			CharacterData cd = (CharacterData) child;
			return cd.getData();
		}
		return "?";
	}

	/*
	 * // * TODO: check the format of placenames ... i.e., the order of
	 * concatenation //
	 */
	// private String concatenatePlaceName(){
	// logger.info("Concatenating placename");
	// placeName = "";
	// if(name != "?"){
	// placeName += name+" ";
	// }
	// if(line1 != "?"){
	// placeName += line1+" ";
	// }
	// if(line2 != "?"){
	// placeName += line2+" ";
	// }
	// if(line3 != "?"){
	// placeName += line3+" ";
	// }
	// if(line4 != "?"){
	// placeName += line4+" ";
	// }
	// if(house != "?"){
	// placeName +=house+" ";
	// }
	// if(street != "?"){
	// placeName += street+" ";
	// }
	// if(xstreet != "?"){
	// placeName += xstreet+" ";
	// }if(postal != "?"){
	// placeName += postal+" ";
	// }if(neighborhood != "?"){
	// placeName += neighborhood+" ";
	// }if(city != "?"){
	// placeName += city+" ";
	// }if(county != "?"){
	// placeName += county+" ";
	// }if(state != "?"){
	// placeName += state+" ";
	// }if(country != "?"){
	// placeName += country+" ";
	// }
	// logger.info("PLACENAME "+placeName);
	// return placeName;
	//
	// }

	protected String getWoeid() {
		return woeid;
	}

	protected String getPlaceTypeName() {
		return placeTypeName;
	}

	protected String getName() {
		return name;
	}

	protected String getCountryType() {
		return countryType;
	}

	protected String getCountryCode() {
		return countryCode;
	}

	protected String getCountryName() {
		return countryName;
	}

	protected String getAdmin1Type() {
		return admin1Type;
	}

	protected String getAdmin1Code() {
		return admin1Code;
	}

	protected String getAdmin1Name() {
		return admin1Name;
	}

	protected String getAdmin2Type() {
		return admin2Type;
	}

	protected String getAdmin2Code() {
		return admin2Code;
	}

	protected String getAdmin2Name() {
		return admin2Name;
	}

	protected String getAdmin3Type() {
		return admin3Type;
	}

	protected String getAdmin3Code() {
		return admin3Code;
	}

	protected String getAdmin3Name() {
		return admin3Name;
	}

	protected String getLocality1() {
		return locality1;
	}

	protected String getLocality2() {
		return locality2;
	}

	protected String getPostalType() {
		return postalType;
	}

	protected String getPostalCode() {
		return postalCode;
	}

	protected double[] getCentroid() {
		return centroid;
	}

	protected double[][] getBoundingBox() {
		return boundingBox;
	}

	public String getPlaceTypeNameCode() {
		return placeTypeNameCode;
	}

	/*
	 * just for testing
	 */
	public static void main(String[] args) {

		YahooGeoplanetXMLResponseParser test = new YahooGeoplanetXMLResponseParser(
				"<?xml version=\"1.0\" encoding=\"UTF-8\"?><ResultSet version=\"1.0\"><Error>0</Error><ErrorMessage>No error</ErrorMessage><Locale>us_US</Locale><Quality>0</Quality><Found>1</Found><Result><quality>60</quality><latitude>37.422676</latitude><longitude>-121.817600</longitude><offsetlat>37.422668</offsetlat><offsetlon>-121.745209</offsetlon><radius>12900</radius><name></name><line1></line1><line2>Milpitas, CA  95035</line2><line3></line3><line4>United States</line4><house></house><street></street><xstreet></xstreet><unittype></unittype><unit></unit><postal>95035</postal><neighborhood></neighborhood><city>Milpitas</city><county>Santa Clara County</county><state>California</state><country>United States</country><countrycode>US</countrycode><statecode>CA</statecode><countycode></countycode><uzip>95035</uzip><hash></hash><woeid>12797523</woeid><woetype>11</woetype></Result></ResultSet><!-- gws13.maps.ch1.yahoo.com uncompressed/chunked Wed Mar  2 12:54:12 PST 2011 -->");

		test.parseXML();
		// test.logger.info(test.getPlaceName());

	}

}
