package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * parses the response from querying yahoo geoplanet
 * provides methods for extracting relevant information 
 * 
 * example yahoo output:
 * 
 <?xml version="1.0" encoding="UTF-8"?>
<places xmlns="http://where.yahooapis.com/v1/schema.rng" xmlns:yahoo="http://www.yahooapis.com/v1/base.rng" yahoo:start="0" yahoo:count="30" yahoo:total="30">
	<place yahoo:uri="http://where.yahooapis.com/v1/place/2345249" xml:lang="en-US">
		<woeid>2345249</woeid>
		<placeTypeName code="8">County</placeTypeName>
		<name>Carlow</name>	
	</place>
	<place yahoo:uri="http://where.yahooapis.com/v1/place/2345250" xml:lang="en-US">
		<woeid>2345250</woeid>
		<placeTypeName code="8">County</placeTypeName>
		<name>Cavan</name>
	</place>
	<place yahoo:uri="http://where.yahooapis.com/v1/place/12471146" xml:lang="en-US">
		<woeid>12471146</woeid>
		<placeTypeName code="13">Island</placeTypeName>
		<name>Saltee Islands</name>
	</place>
	<place yahoo:uri="http://where.yahooapis.com/v1/place/24548851" xml:lang="en-US">
		<woeid>24548851</woeid>
		<placeTypeName code="13">Island</placeTypeName>
		<name>Ireland</name>
	</place>
	<place yahoo:uri="http://where.yahooapis.com/v1/place/55863700" xml:lang="en-US">
		<woeid>55863700</woeid>
		<placeTypeName code="24">Colloquial</placeTypeName>
		<name>Beara Peninsula</name>
	</place>
</places>

 */
class YahooGeoplanetGetChildrenResponseParser {

	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
	/*
	 * store each attribute from the xml file in a variable
	 */
	private String woeid = "";
	private String placeTypeName = "";
	private String placeTypeNameCode="";
	private String name = "";
	private ArrayList<String> childList;
	private ArrayList<String> childListTownsAndSuburbs; //for services that require only town and suburb children (eg: weather)
	private ArrayList<String> childListWOEIDS;

	private String XML;

	/*
	 * constructor takes in an xml string to be parsed
	 */
	public YahooGeoplanetGetChildrenResponseParser(String YahooResponse) {
		this.XML = YahooResponse;
	}


	/*
	 * retrieve relevant information from xml and store in relevant variables
	 */
	public void parseXML() {
		childList = new ArrayList<String>();
		childListTownsAndSuburbs = new ArrayList<String>();
		childListWOEIDS = new ArrayList<String>();
//		logger.info("parsing xml: " +XML);
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(XML));

			Document doc = db.parse(is);

			//parent node
			NodeList nodes = doc.getElementsByTagName("place");
			for(int j = 0; j<nodes.getLength(); j++){
				NodeList nodes2 = nodes.item(j).getChildNodes();
				for (int i = 0; i < nodes2.getLength(); i++) {
					Element element = (Element) nodes2.item(i);
//					logger.info("element tag name: " +element.getTagName());
					if(element.getTagName() == "woeid"){
						woeid = element.getTextContent();
//						logger.info("WOEID: " +woeid);
						childListWOEIDS.add(woeid);
					}
					else if(element.getTagName() == "placeTypeName"){
						placeTypeNameCode = element.getAttribute("code");
						placeTypeName = element.getTextContent();
						//					logger.info("Placetypnamecode: "+placeTypeNameCode+" , placetypename: "+placeTypeName);
					}
					else if(element.getTagName() == "name"){
						name = element.getTextContent();
						//						logger.info("name: " +name);
						childList.add(name);
						//						if(placeTypeName.equalsIgnoreCase("town") || placeTypeName.equalsIgnoreCase("suburb")){
						childListTownsAndSuburbs.add(name);
						//						}
						//					logger.info("name: " +name);
					}

				}  
			}



		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//		concatenatePlaceName();
	}

	//retrieve attribute value
	private String getCharacterDataFromElement(Element e) {
		Node child = e.getFirstChild();
		if (child instanceof CharacterData) {
			CharacterData cd = (CharacterData) child;
			return cd.getData();
		}
		return "?";
	}

	protected String getWoeid() {
		return woeid;
	}

	protected String getPlaceTypeName() {
		return placeTypeName;
	}

	protected String getName() {
		return name;
	}

	public String getPlaceTypeNameCode() {
		return placeTypeNameCode;
	}

	public ArrayList<String> getChildList(){
		return childList;
	}
	
	public ArrayList<String> getWOEIDChildList(){
		return childListWOEIDS;
	}

	public ArrayList<String> getChildListTownsAndSuburbs(){
		return childListTownsAndSuburbs;
	}

	///*
	// * just for testing
	// */
	// public static void main(String[] args) {
	//
	//	 YahooGeoplanetXMLResponseParser test = new YahooGeoplanetXMLResponseParser(
	//	 "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ResultSet version=\"1.0\"><Error>0</Error><ErrorMessage>No error</ErrorMessage><Locale>us_US</Locale><Quality>0</Quality><Found>1</Found><Result><quality>60</quality><latitude>37.422676</latitude><longitude>-121.817600</longitude><offsetlat>37.422668</offsetlat><offsetlon>-121.745209</offsetlon><radius>12900</radius><name></name><line1></line1><line2>Milpitas, CA  95035</line2><line3></line3><line4>United States</line4><house></house><street></street><xstreet></xstreet><unittype></unittype><unit></unit><postal>95035</postal><neighborhood></neighborhood><city>Milpitas</city><county>Santa Clara County</county><state>California</state><country>United States</country><countrycode>US</countrycode><statecode>CA</statecode><countycode></countycode><uzip>95035</uzip><hash></hash><woeid>12797523</woeid><woetype>11</woetype></Result></ResultSet><!-- gws13.maps.ch1.yahoo.com uncompressed/chunked Wed Mar  2 12:54:12 PST 2011 -->");
	//
	//	 test.parseXML();
	//	 //		 test.logger.info(test.getPlaceName());
	//
	// }

}
