package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;




/*
 * provides methods for resolving a woeid to a location
 * and a location to a woeid
 */
public class WoeidManager {
	private static final Logger logger = Logger.getLogger(WoeidManager.class.getName());
	
	 //yahoo application key TODO: remove from here and read from file
	private final String yahooID = "FDzIWXfV34HtzjVF8_npsmwe0YQI3AgcPQN3FhtIBPqyLfce7T_.9.3Qgd9CIJZHgk5sjAmunFwco0Vl4DPtNejMZ4tXggM-";
//	http://where.yahooapis.com/v1/places.q('northfield%20mn%20usa')?appid=FDzIWXfV34HtzjVF8_npsmwe0YQI3AgcPQN3FhtIBPqyLfce7T_.9.3Qgd9CIJZHgk5sjAmunFwco0Vl4DPtNejMZ4tXggM-
//	private String newWoeidRequestString = "http://where.yahooapis.com/v1/places.q('"
		private String woeidRequestString = "http://where.yahooapis.com/geocode?location="; //have place name and requesting woeid
	private String placeNameRequestString = "http://where.yahooapis.com/geocode?woeid="; //have woeid and requesting placename
	private URL woeidRequestURL; //url for sending request
	private URL placeNameRequestURL; //url for sending request
	private YahooXMLResponseParser parser; //parser for yahoo's xml response

	public WoeidManager(){

	}
	
	public int convertCoordinatesToWoeid(String latitude, String longitude){
		latitude = latitude.trim();
		longitude = longitude.trim();
		logger.info("trying to convert coordinates: latitude="+latitude+", longitude="+longitude);
		String response = "";
		
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
		String place = latitude+",+"+longitude+"&gflags=R";
		
		String url = formatURL(woeidRequestString, place); //format url
		
		try {
			//send request
			System.out.println("url: " + url);
			woeidRequestURL = new URL(url);
			URLConnection urlConnection =  woeidRequestURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add yahoo's xml output to response string
			}

			
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		logger.info("about to parse: " +response);
		//parse yahoo's xml response
		parser = new YahooXMLResponseParser(response);
		parser.parseXML();
		String responseString = parser.getWoeid(); //get the information we want from the xml returned
		if(responseString.equalsIgnoreCase("?") || responseString == null){
			return -1;
		}
		logger.info("woeid: " +responseString);
		return Integer.parseInt(responseString); //convert and return the woeid as an integer
	}

	/*
	 * converts a placename string to a yahoo woeid
	 */
	public int convertPlaceNameToWoeid(String placeName){

		
		String response = "";
		
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
		ProcessPlaceName process = new ProcessPlaceName(placeName);
		placeName = process.removeSpaces();
//		if(placeName.contains(",")){
//			placeName = placeName.replace(",", "+");
//		}
		woeidRequestString = formatURL(woeidRequestString, placeName); //format url
		
		try {
			//send request
			woeidRequestURL = new URL(woeidRequestString);
			URLConnection urlConnection =  woeidRequestURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add yahoo's xml output to response string
			}

			
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//parse yahoo's xml response
		parser = new YahooXMLResponseParser(response);
		parser.parseXML();
		String responseString = parser.getWoeid(); //get the information we want from the xml returned
		if(responseString.equalsIgnoreCase("?")){
			return -1;
		}
		try{
			return Integer.parseInt(responseString); //convert and return the woeid as an integer
			
		}catch(NumberFormatException e){
			return -1;
		}
		
	}
	
	/*
	 * convert a yahoo woeid to latlong coordinates
	 */
	public String convertWoeidToLatlong(int woeid){
	String woeidString = Integer.toString(woeid);
		
		String response = "";
		placeNameRequestString = formatURL(placeNameRequestString, woeidString); //format url
		
		try {
			//send request
			placeNameRequestURL = new URL(placeNameRequestString);
			URLConnection urlConnection =  placeNameRequestURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add yahoo's xml output to response string
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//parse xml response
		parser = new YahooXMLResponseParser(response);
		parser.parseXML();
		String responseString = parser.getLatitude()+","+parser.getLongitude(); //get the information we want from the xml returned
		return responseString;
	}

	/*
	 * convert a yahoo woeid to its placename string
	 */
	public String convertWoeidToPlaceName(int woeid){
		String woeidString = Integer.toString(woeid);
		
		String response = "";
		String url = formatURL(placeNameRequestString, woeidString); //format url
		
		try {
			//send request
			placeNameRequestURL = new URL(url);
			URLConnection urlConnection =  placeNameRequestURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add yahoo's xml output to response string
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//parse xml response
		parser = new YahooXMLResponseParser(response);
		parser.parseXML();
		String responseString = parser.getPlaceName(); //get the information we want from the xml returned
		return responseString;
	}

	/*
	 * concatenate url
	 */
	private String formatURL(String request, String input){
		
		return request+input+"&appid="+yahooID;
		
	}
	


	/*
	 * just for testing
	 */
	public static void main(String[] args){
		
		WoeidManager manager = new WoeidManager();
		logger.info("Converting placename to Woeid returns: "+manager.convertPlaceNameToWoeid("Ireland"));
//		logger.info("Converting woeid to placename returns: "+manager.convertWoeidToPlaceName(23424803));
//		logger.info("converting latlong to woeid returns: " +manager.convertCoordinatesToWoeid("53.343761", "-6.24953"));
	}

}
