package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.util.StringTokenizer;

/*
 * Tool for converting a placename string from its natural format to url friendly format
 * and the reverse
 */
public class ProcessPlaceName {

	private String placeName = "";
	
	public ProcessPlaceName(String nameString){
		this.placeName = nameString;
	}
	
	/*
	 * check placename for " "'s and replace all with "+"
	 */
	public String removeSpaces(){
		String newPlaceName = ""; //holder for our processed placename
		placeName=placeName.trim(); //remove any blank spaces at the end of placename
		if (placeName.contains(" ")){ //if the placename contains any space characters we want to replace them with "+"
			StringTokenizer tokenizer = new StringTokenizer(placeName, " "); //tokenizer will split the string everywhere there is a " "
			newPlaceName = tokenizer.nextToken(); //start newplacename with the first part of original
			while(tokenizer.hasMoreTokens()){
				newPlaceName+="+"+tokenizer.nextToken(); //and add each token to our new placename with a "+" inbetween
			}
			
			return newPlaceName; // return our processed placename
		}
		return placeName; //if no changes were necessary return the original
		
	}
	
	/*
	 * check placename for "+"'s and replace all with " "
	 */
	public String removePluses(){
		String newPlaceName = ""; //holder for our processed placename
		placeName=placeName.trim(); //remove any blank spaces at the end of placename
		if (placeName.contains("+")){ //if the placename contains any "+" characters we want to replace them with " "
			StringTokenizer tokenizer = new StringTokenizer(placeName, "+"); //tokenizer will split the string everywhere there is a "+"
			newPlaceName = tokenizer.nextToken(); //start newplacename with the first part of original
			while(tokenizer.hasMoreTokens()){
				newPlaceName+=" "+tokenizer.nextToken(); //and add each token to our new placename with a "+" inbetween
				
			}
			
			return newPlaceName; // return our processed placename
		}
		return placeName; //if no changes were necessary return the original
		
	}
	
	/*
	 * just for testing
	 */
	public static void main(String[] args){
		ProcessPlaceName process = new ProcessPlaceName("http://where.yahooapis.com/geocode?location=170+South+Market+St.,+San+Jose,+C");
//		System.err.println(process.removePluses());
		ProcessPlaceName process2 = new ProcessPlaceName("http://where.yahooapis.com/geocode?location=170 South Market St., San Jose, C");
//		System.err.println(process.removeSpaces());
	}
}
