package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * calculates the bounding box of a given location (by name or central point (long/lat)
 * uses yahoo geoplanet http://developer.yahoo.com/geo/geoplanet/
 */
public class PlaceManager {
	private static final Logger logger = Logger.getLogger(PlaceManager.class.getName());
	
	static {
		logger.setLevel(Level.FINEST);
	}

	//application key TODO: remove and read from file
	private final String yahooID = "FDzIWXfV34HtzjVF8_npsmwe0YQI3AgcPQN3FhtIBPqyLfce7T_.9.3Qgd9CIJZHgk5sjAmunFwco0Vl4DPtNejMZ4tXggM-";

	private String requestDataUsingPlaceName = "http://where.yahooapis.com/v1/places.q("; //common part of all queries by placename
	private String requestDataUsingWOEID = "http://where.yahooapis.com/v1/place/"; //common part of all queries by woeid

	private URL requestDataURL; //URL for sending query
	private YahooGeoplanetXMLResponseParser parser; //parses yahoo's xml response and gives access to required information

	/*
	 * default constructor
	 */
	public PlaceManager(){

	}

	public double[] getCoordinates(String placeName){
		logger.info("getting coordinates for placename:  "+placeName);
		if(placeName.matches(".*\\d.*") || placeName.length()<2){
			return null;
		}
		String response = "";
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
		ProcessPlaceName process = new ProcessPlaceName(placeName);
		placeName = process.removeSpaces();

		requestDataUsingPlaceName+=placeName+")?appid="+yahooID; //format urlString

		response = sendRequest(requestDataUsingPlaceName);
	
		
		logger.info("Yahoo response " + response);
		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML();
		
		double[] centroid = parser.getCentroid();
	
		return centroid;
	}
	
//	public String checkContainingCountry(String latlon){
//		String response = "";
//		
//		return response;
//	}
	
	/*
	 * checks the placetype for the location provided
	 */
	public String checkPlaceType(String placeName){
		String response = "";
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
//		logger.info("placename before processing: " +placeName);
		ProcessPlaceName process = new ProcessPlaceName(placeName);
		placeName = process.removeSpaces();
//		logger.info("placename after processing: " +placeName);

		requestDataUsingPlaceName+=placeName+")?appid="+yahooID; //format urlString

		response = sendRequest(requestDataUsingPlaceName);

		logger.info(response);
		
		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML();
		String placeType = parser.getPlaceTypeName();
		String code = parser.getPlaceTypeNameCode();
		return placeType;

	}
	
	/*
	 * checks the placetype for the location provided
	 */
	public int checkPlaceCode(int woeid){
		String response = "";
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	



		requestDataUsingWOEID+=woeid+"?appid="+yahooID; //format urlString

		response = sendRequest(requestDataUsingWOEID);

		logger.info(response);
		
		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML();
		String placeType = parser.getPlaceTypeName();
		int code = Integer.parseInt(parser.getPlaceTypeNameCode());
		return code;

	}
	

	/*
	 * checks the placetypename code for the location provided
	 */
	public int checkPlaceTypeCODE(String placeName){
		String response = "";
		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
		ProcessPlaceName process = new ProcessPlaceName(placeName);
		placeName = process.removeSpaces();

		requestDataUsingPlaceName+=placeName+")?appid="+yahooID; //format urlString

		response = sendRequest(requestDataUsingPlaceName);

		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML();
		String placeType = parser.getPlaceTypeName();
		int code = Integer.parseInt(parser.getPlaceTypeNameCode());
		return code;

	}
	
	/*
	 * retrieves and returns a list of all the child places belonging to a parent place
	 * (eg: ireland would retrieve dublin, wicklow, etc..)
	 * 
	 * TODO: for the purposes of the yahoo weather service we need to check the top 5 woeids returned for a placename and
	 * choose the most suitable. (E.G: for 'Wicklow' the woeid automatically returned is 2345274 when we want 562503. 
	 * The first is a similar area to the second but yahoo do not return any weather information for the first
	 * 
	 * NB: setting 'count=0' in the url retrieves *all* children
	 */
	public ArrayList<String> getChildPlaces(String placeName){
//		logger.info("Finding child places for: " +placeName);
		String childUrlString = "http://where.yahooapis.com/v1/place/";
		int woeid = new WoeidManager().convertPlaceNameToWoeid(placeName);
		String endUrl=		woeid+"/children;count=0?appid="+yahooID;
		childUrlString+=endUrl; //request url string is concatenated
		
		//send request and receive response
		String response = sendRequest(childUrlString);
		logger.info("Response for children: " +response);
		YahooGeoplanetGetChildrenResponseParser parser = new YahooGeoplanetGetChildrenResponseParser(response);
		parser.parseXML();
		ArrayList<String> childList = parser.getChildList();
		
		return childList;
		
	}
	
	public ArrayList<String> getChildWoeids(int woeid){
//		logger.info("Finding child places for: " +placeName);
		String childUrlString = "http://where.yahooapis.com/v1/place/";

		String endUrl=		woeid+"/children;count=0?appid="+yahooID;
		childUrlString+=endUrl; //request url string is concatenated
		
		//send request and receive response
		String response = sendRequest(childUrlString);
		logger.info("Response for children: " +response);
		YahooGeoplanetGetChildrenResponseParser parser = new YahooGeoplanetGetChildrenResponseParser(response);
		parser.parseXML();
		ArrayList<String> childList = parser.getChildList();
		
		return childList;
		
	}
	
	/*
	 * http://where.yahooapis.com/v1/place/2507854/descendants?appid=[yourappidhere]
	 * 
	 * http://where.yahooapis.com/v1/place/2488042/children.degree(2)?appid=[yourappidhere]
	 */
	public ArrayList<String> getDescendantsOfWOEID(int woeid){
		logger.info("getting child places..");
		String childUrlString = "http://where.yahooapis.com/v1/place/";
		ArrayList<String> childList = null;
//		int woeid2 = new WoeidManager().convertPlaceNameToWoeid("ireland");

		String endUrl=woeid+"/children.degree(1);count=0?appid="+yahooID;
		childUrlString+=endUrl; //request url string is concatenated
		
		//send request and receive response
		String response = sendRequest(childUrlString);
		logger.info(response);
		YahooGeoplanetGetChildrenResponseParser parser = new YahooGeoplanetGetChildrenResponseParser(response);
		parser.parseXML();
		childList = parser.getChildListTownsAndSuburbs();
		logger.info("size of child list: " +childList.size());
	
		
		return childList;
	}
	
	/*
	 * retrieves and returns a list of all the child places belonging to a parent place
	 * (eg: ireland would retrieve dublin, wicklow, etc..)
	 * 
	 * NB: setting 'count=0' in the url retrieves *all* children
	 */
	public ArrayList<String> getChildPlacesTownsAndSuburbsUsingWOEID(int woeid){
//		logger.info("getting child places..");
		String childUrlString = "http://where.yahooapis.com/v1/place/";
		ArrayList<String> childList = null;
	
		String endUrl=		woeid+"/children;count=0?appid="+yahooID;
		childUrlString+=endUrl; //request url string is concatenated
		
		//send request and receive response
		String response = sendRequest(childUrlString);
//		logger.info(response);
		YahooGeoplanetGetChildrenResponseParser parser = new YahooGeoplanetGetChildrenResponseParser(response);
		parser.parseXML();
		childList = parser.getChildListTownsAndSuburbs();
//		logger.info("size of child list: " +childList.size());
	
		
		return childList;
		
	}
	
	/*
	 * retrieves and returns a list of all the child places belonging to a parent place
	 * (eg: ireland would retrieve dublin, wicklow, etc..)
	 * 
	 * NB: setting 'count=0' in the url retrieves *all* children
	 */
	public ArrayList<String> getChildPlacesTownsAndSuburbs(String placeName){
		String childUrlString = "http://where.yahooapis.com/v1/place/";
		int woeid = new WoeidManager().convertPlaceNameToWoeid(placeName);
		String endUrl=		woeid+"/children;count=0?appid="+yahooID;
		childUrlString+=endUrl; //request url string is concatenated
		
		//send request and receive response
		String response = sendRequest(childUrlString);
		
		YahooGeoplanetGetChildrenResponseParser parser = new YahooGeoplanetGetChildrenResponseParser(response);
		parser.parseXML();
		ArrayList<String> childList = parser.getChildListTownsAndSuburbs();
		
		return childList;
		
	}
	
	
	
	
	/*
	 * sends the provided request to yahoo and retrieves the xml string response
	 */
	private String sendRequest(String request){
		String response = "";
//		logger.info("REQUEST THAT IS BREAKING: " +request);
		try {
			//send request
			requestDataURL = new URL(request);
			URLConnection urlConnection =  requestDataURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add xml response to response string
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return response;
	}



	/*
	 * just for testing
	 */
	public static void main (String[] args){
		PlaceManager manager = new PlaceManager();
//		String placeString = manager.checkPlaceType("ireland");
//		logger.info("Type: " +placeString);
//		manager.getChildPlaces("Ireland");
//		double[] latlong = manager.getCoordinates("ireland");
//		logger.info("lat: " +latlong[0] + ", long: " +latlong[1]);
//		double [] t = manager.getCoordinates("asdada 090 sdfsd");
//		if(t == null){
//			logger.info("worked");
//		}else{
//			logger.info("didnt work");
//		}
//		if(manager.getCoordinates("sdfsf 090") ==null){
//			logger.info("worked this time");
//		}else{
//			logger.info("didnt wrk again");
//		}
////		manager.getDescendantsOfWOEID(23424803);
		
//		int code = manager.checkPlaceCode(24554868);
//		logger.info("code:  " +code);
		
		double[] locationLatlong =  manager.getCoordinates("Fortescue Road, australia");
		System.err.println("coordinates: " +locationLatlong[0]+", "+locationLatlong[1]);
		
	}

}
