package ie.ucd.sixth.core.cyber.utils.yahoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

/*
 * calculates the bounding box of a given location (by name or central point (long/lat)
 * uses yahoo geoplanet http://developer.yahoo.com/geo/geoplanet/
 */
public class BoundingBoxManager {
	
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);

	//application key TODO: remove and read from file
	private final String yahooID = "FDzIWXfV34HtzjVF8_npsmwe0YQI3AgcPQN3FhtIBPqyLfce7T_.9.3Qgd9CIJZHgk5sjAmunFwco0Vl4DPtNejMZ4tXggM-";

	private String requestDataUsingPlaceName = "http://where.yahooapis.com/v1/places.q("; //common part of all queries by placename
	private String requestDataUsingWOEID = "http://where.yahooapis.com/v1/place/"; //common part of all queries by woeid

	private URL requestDataURL; //URL for sending query
	private YahooGeoplanetXMLResponseParser parser; //parses yahoo's xml response and gives access to required information

	/*
	 * default constructor
	 */
	public BoundingBoxManager(){

	}

	/*
	 * converts the provided placename string to its geographical boundingbox (SW(lat,long) NE(lat,long))
	 */
	public double[][] convertPlaceNameToBoundingBox(String placeName){
		double[][] bb = new double[2][2]; //2d array for storing the boundingbox
		String response = "";

		/*
		 * before we format the url we need to make sure the placename is in the correct format
		 * i.e., that it has "+" between locations in the address rather than " "
		 */	
		ProcessPlaceName process = new ProcessPlaceName(placeName);
		placeName = process.removeSpaces();

		requestDataUsingPlaceName+=placeName+")?appid="+yahooID; //format urlString

		try {
			//send request
			requestDataURL = new URL(requestDataUsingPlaceName);
			URLConnection urlConnection =  requestDataURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add xml response to response string
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML(); 

		//get the information we want from the xml returned
		bb = parser.getBoundingBox();
		return bb;
	}
	

	/*
	 * converts the provided woeid string to its geographical boundingbox (SW(lat,long) NE(lat,long))
	 */
	public double[][] convertWoeidToBoundingBox(String woeid){
		double[][] bb = new double[2][2]; //2d array for storing the boundingbox
		String response = "";


		requestDataUsingWOEID+=woeid+"?appid="+yahooID; //format urlString

		try {
			//send request
			requestDataURL = new URL(requestDataUsingPlaceName);
			URLConnection urlConnection =  requestDataURL.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add xml response to response string
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//process yahoo's xml response
		parser = new YahooGeoplanetXMLResponseParser(response);
		parser.parseXML();
		//get the information we want from the xml returned
		bb = parser.getBoundingBox();
		return bb;
	}
	
	/*
	 * just for testing
	 */
	public static void main (String[] args){
		BoundingBoxManager manager = new BoundingBoxManager();
		manager.convertPlaceNameToBoundingBox("ireland");
		
		manager.convertWoeidToBoundingBox("23424803");
	}

}
