package ie.ucd.sixth.core.cyber.utils.parsers;


import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlToMapConverter {
	private static final Logger log = Logger.getLogger(XmlToMapConverter.class.getName());
	static {
		log.setLevel(Level.ALL);
	}

	Map<String, String> dataMap;
	/*
	 * use this index to append to "keys" (i.e., modality names) that are recurring so that they don't get over written in the map
	 * e.g., if there are two twitter.name modalities they will be replaced with twitter.name and twitter.name2;
	 */
	private int modalityIndex = 0;
	private boolean fromJson = false;

	public String convertToJsonFromXML(String xml){
		XMLSerializer serializer = new XMLSerializer(); 
		JSON json = serializer.read(xml);
		System.out.println(json);
		return json.toString();
	}

	public Map<String, String> parse(String xml){
		fromJson = false;
		if(xml.startsWith("{") || xml.startsWith("[")){ //we received json and need to convert it to xml before we can proceed
			xml = parseJson(xml);
			if(xml==null){
				return null;
			}
			fromJson = true;
		}

		dataMap = new LinkedHashMap<String, String>();


		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db;

		try {
			db = dbf.newDocumentBuilder();


			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(xml));
			Document doc = db.parse(is);

			//parent node
			NodeList nodes = doc.getChildNodes();
			if(nodes!=null){
				Node rootNode = nodes.item(0);//the root node (every xml file will have 1 root node)

				parseNode(rootNode, "");
			}

		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		} catch (SAXException e) {
			e.printStackTrace();
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		} catch(Exception e){
			e.printStackTrace();
			return null;
		} 

		if(fromJson){
			Map<String, String> newDataMap = new LinkedHashMap<String, String>();
			for (Entry<String, String> entry : dataMap.entrySet()) {
				String key = entry.getKey();
				String value = entry.getValue();

				key = key.replaceFirst("o\\.", "");
				key = key.replaceAll("\\.e\\.", ".");


				newDataMap.put(key, value);
			}
			return newDataMap;
		}

		return dataMap;
	}

	private void parseNode(Node node, String tag){

		String nodeName = node.getNodeName();
		if(nodeName!=null && !nodeName.isEmpty() ){


			String nodeTag = tag+"."+node.getNodeName();
			if(tag.isEmpty()){
				nodeTag = node.getNodeName();
			}
			/*
			 * append the tag using our index
			 * this loop will increase the index until it finds a value that is unique amongst this nodes peers
			 */
			while(hasMatchingSiblings(node, nodeTag)){
				nodeTag = nodeTag+"."+modalityIndex++;
			}
			String textContent = node.getNodeValue();
			if(textContent !=null && !textContent.equalsIgnoreCase("null")){
				if(nodeTag.endsWith(".#text")){
					nodeTag = nodeTag.replace(".#text", "");
				}

				dataMap.put(nodeTag, textContent);
			}


			if(node.hasAttributes()){

				NamedNodeMap attributes = node.getAttributes();
				for(int i =0; i<attributes.getLength(); i++){
					Node attributeName = attributes.item(i);
					String attributeTag = nodeTag+"."+attributeName.getNodeName();
					String attributeVAlue = attributeName.getNodeValue();
					if(attributeTag.endsWith(".#text")){
						attributeTag = attributeTag.replace(".#text", "");
					}
					dataMap.put(attributeTag, attributeVAlue);
				}
			}

			if(node.hasChildNodes()){// if this node has childNodes we want to parse all of them too
				NodeList childNodes = node.getChildNodes();
				for(int i =0; i<childNodes.getLength(); i++){
					parseNode(childNodes.item(i), nodeTag);


				}
			}


		}

	}

	public boolean containsTag(String tag){
		if(dataMap.containsKey(tag)){
			return true;
		}else{
			return false;
		}
	}

	/*
	 * before parsing a node check if this node has siblings with the same tag
	 * if yes - then we need to append an index to the tag to differentiate between these nodes
	 * e.g: some API's return information about multiple elements of the same type in one xml response
	 */
	public boolean hasMatchingSiblings(Node node, String tag){
		String[] tagElements = tag.split("\\.");
		String tagEnd = tagElements[tagElements.length-1];

		NodeList siblings = node.getParentNode().getChildNodes(); //get all siblings

		if(siblings!=null && siblings.getLength()>1){ //if there is only one "sibling" it is this node
			for(int i =0; i<siblings.getLength(); i++){
				if(siblings.item(i).getNodeType() == Node.ELEMENT_NODE){
					if(!siblings.item(i).equals(node)){
						String nodeName = siblings.item(i).getNodeName();
						if(tagEnd.equalsIgnoreCase(nodeName)){
							return true;
						}
					}


				}
			}

		}

		return false;
	}


	public String parseJson(String json){
//				System.out.println("attempting to parse json: " +json);
		XMLSerializer serializer = new XMLSerializer(); 
		
		JSON jsonObject = JSONSerializer.toJSON( json ); 
		String xml = "";
		try{
		xml = serializer.write( jsonObject );  
		//        System.out.println(xml);  
		}catch(nu.xom.IllegalCharacterDataException e){
			System.out.println(e);
			return null;
		}catch(nu.xom.IllegalNameException e){
			System.out.println(e);
			return null;
		}catch(nu.xom.IllegalDataException e){
			System.out.println(e);
			return null;
		}
		return xml;
	}


	/*
	 * just for local testing
	 */
	public static void main(String[] args){




		XmlToMapConverter test = new XmlToMapConverter();
		//		Map<String, String> dataMap = test.parse("<weather name=\'somename\'><weathernode><insideweathernode>data</insideweathernode></weathernode></weather>");
		//		Set<String> set = dataMap.keySet();
		//		for (String string : set) {
		//			log.info("key: " +string+", value: " +dataMap.get(string));
		//		}

		String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><users><user><twitter_id>10978552</twitter_id><twitter_screen_name>olgamurdoch</twitter_screen_name><score><kscore>46.73</kscore><slope>-0.11</slope><description>is effectively using social media to influence their network across a variety of topics</description><kclass_id>11</kclass_id><kclass>Specialist</kclass><kclass_description>You may not be a celebrity, but within your area of expertise your opinion is second to none. Your content is likely focused around a specific topic or industry with a focused, highly-engaged audience.</kclass_description><kscore_description>is effectively using social media to influence their network across a variety of topics</kscore_description><network_score>31.85</network_score><amplification_score>20</amplification_score><true_reach>421</true_reach><delta_1day>-0.18</delta_1day><delta_5day>-0.87</delta_5day></score></user></users>";
		String json3 = "{\"status\": 200,\"users\": [{\"twitter_id\": \"10978552\",\"twitter_screen_name\": \"olgamurdoch\",\"score\": {\"kscore\": 46.73,\"slope\": -0.11,\"description\": \"is effectively using social media to influence their network across a variety of topics\",\"kclass_id\": 11,\"kclass\": \"Specialist\",\"kclass_description\": \"You may not be a celebrity, but within your area of expertise your opinion is second to none. Your content is likely focused around a specific topic or industry with a focused, highly-engaged audience.\",\"kscore_description\": \"is effectively using social media to influence their network across a variety of topics\",\"network_score\": 31.85,\"amplification_score\": 20,\"true_reach\": 421,\"delta_1day\": -0.18,\"delta_5day\": -0.87}}]}";
		String json2 = "{\"status\": 200,\"users\": [{\"twitter_screen_name\": \"olgamurdoch\",\"kscore\": 46.73}]}";
		String json = "{\"status\":200,\"headers\":[],\"body\":{\"error\":\"No users\"}}";
//		Map<String, String> dataMap = test.parse(json3);
//		Set<String> set = dataMap.keySet();
//		for (String string : set) {
//			//			System.out.println("key: " +string+", value: " +dataMap.get(string));
//		}
//
//		Map<String, String> dataMap2 = test.parse(xml);
//		Set<String> set2 = dataMap2.keySet();
//		for (String string : set2) {
//			//			System.out.println("key: " +string+", value: " +dataMap2.get(string));
//		}
		
		String jsonstring = test.convertToJsonFromXML(xml);
	}


}
