package ie.ucd.sixth.core.cyber.utils.html;

import ie.ucd.sixth.core.cyber.utils.TextParser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

public class WebLoginFacility {
	private static final Logger logger = Logger.getLogger(WebLoginFacility.class.getName());

	private String urlString = "";
	HtmlPage page = null;
	private WebClient webClient;
	private TextParser textParser;

	private String testString = "www.timeview2.net";

	public WebLoginFacility(String urlString){
		logger.info("creating html scraper");
		this.urlString = urlString;
		accessPage(urlString);
		textParser = new TextParser();
	}

	public void setNewUrl(String url){
		accessPage(url);
	}

	private void accessPage(String url){
		webClient = new WebClient();
		try {
			webClient.setThrowExceptionOnScriptError(false);
			//need this so client doesnt crash trying to log in to page
			webClient.setRefreshHandler(new WaitingRefreshHandler());
			page = webClient.getPage(url);
		} catch (FailingHttpStatusCodeException e) {
			logger.severe("BasicHtmlScraper: catching exception in HTMLUNIT");
			e.printStackTrace();

		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		logger.info("CyberCore - WebLoginFacility: have page...");
//		logger.info(page.asText());
	}

	public void getLoginForm(String formID) throws IOException{
		webClient.setJavaScriptEnabled(false);
		HtmlForm form = (HtmlForm)page.getByXPath("//form[@name='userid']").get(0);

		if(form!=null){
			logger.info(form.asXml());
			form.getInputByName("user").setValueAttribute("s04bf1b6");
			logger.info("checking page for change..... ");
			logger.info(form.asXml());
//			form.getInputByName("pass").setValueAttribute("dfsdfsdfsdf");
//			logger.info(form.asXml());	

		}else{
			logger.info("couldnt get form");
		}
		
		HtmlForm form2 = (HtmlForm)page.getByXPath("//form[@name='cplogin']");
		
		if(form2!=null){
			logger.info(form2.asXml());
			form2.getInputByValue("pass").setValueAttribute("hvghvhgv");
			logger.info("checking for change... ");
			logger.info(form2.asXml());
		}
		
		HtmlImage image = (HtmlImage)page.getElementByName("ok_btn");
		HtmlPage newPage = (HtmlPage)  image.click();//			HtmlPage newPage = (HtmlPage) form.getInputByValue("Login").click();

		if(newPage!=null){
			logger.info("have new page...");
			logger.info(newPage.asXml());
		}else{
			logger.info("couldnt load new page..");
		}
		
		//		HtmlForm form = page.getFormByName(formID);
		//        HtmlSubmitInput button = (HtmlSubmitInput) form.getInputByName("btnG");
		//        HtmlPage page2 = (HtmlPage) button.click();
	}

	public void setUrlString(String url){
		this.urlString = url;
		accessPage(urlString);
	}

	public void shutDown() {
		webClient.closeAllWindows();

	}

	/*
	 * just for testing
	 */
	public static void main(String[] args) throws IOException{
		String url = "http://www.ucd.ie";
		WebLoginFacility test = new WebLoginFacility(url);
		String formID = "UserLoginForm";
		test.getLoginForm(formID);
	}

}
