package ie.ucd.sixth.core.cyber.utils.html;

import ie.ucd.sixth.core.cyber.utils.TextParser;

import java.util.List;
import java.util.logging.Logger;

import org.w3c.dom.NamedNodeMap;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;

/*
 * This utility class takes in a html element and outputs the data in xml according to a specified template
 * 
 * TODO:
 * provide a template validation class to ensure all tags have matching close tag etc
 * 
 */
public class HtmlDataToXmlConverter {
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);

	private TextParser textParser;

	public HtmlDataToXmlConverter(){
		textParser = new TextParser();

	}

	public String convertDivToHTML(HtmlDivision div, String template){

		final String classAttribute = "attribute=class";
		final String divContent = "divcontent";
		if(template.contains("attribute")){
			if(div.hasAttributes()){
				if(template.contains(classAttribute)){
					if(div.hasAttribute("class")){
						String attribute = div.getAttribute("class");
						attribute= textParser.makeXmlTagSafe(attribute);
						template=template.replace(classAttribute, attribute);
					}
				}
			}	
		}
		if(template.contains("divcontent")){
			String content = div.getTextContent();
			content=textParser.makeXmlValueSafe(content);
			template=template.replace(divContent, content);
		}

		//		String name = div.get
		return template;
	}


	public String convertNestedTableFromTemplate(HtmlTable table, int tableNumber, String xmlTemplate){
		String template = xmlTemplate;
		//iterate the length of the tables rows and columns and replace the tags and values where necessary
		List<HtmlTableRow> list = table.getRows();
		for(int i = 0; i<list.size(); i++){
			HtmlTableRow row = list.get(i);

			List<HtmlTableCell> cells = row.getCells();
			for(int j = 0; j<cells.size(); j++){
				HtmlTableCell cell = cells.get(j);
				String tableData = cell.getTextContent();
				String compareString = "table"+tableNumber+"row"+i+"col"+j;	
				String compareTag = "<table"+tableNumber+"row"+i+"col"+j+">";	
//				String compareCloseTag = "</table"+tableNumber+"row"+i+"col"+j+">";
				String compareChildTag="<table"+tableNumber+"row"+i+"col"+j+"child";

				if(template.contains(compareChildTag)){
					if(cell.hasChildNodes()){
						DomNodeList<DomNode> x = cell.getChildNodes();
						for(int k = 0; k<x.getLength(); k++){
							String compareAttValue="table"+tableNumber+"row"+i+"col"+j+"child"+k+" attribute='alt'";
							String compareAttribute = "<table"+tableNumber+"row"+i+"col"+j+"child"+k+" attribute='alt'>"; // only one supported
							
							if(template.contains(compareAttValue)){
								DomNode domNode = (DomNode) x.item(k);
								if(domNode.hasAttributes()){
									NamedNodeMap y = domNode.getAttributes();
									if(y!=null){
										String att = y.getNamedItem("alt").getNodeValue();
										if(template.contains(compareAttribute)){
											att = textParser.makeXmlTagSafe(att);
										}else{
											att = textParser.makeXmlValueSafe(att);
										}
										template = template.replace(compareAttValue, att);

									}
								}
							}
						}
					}
				}


				if(template.contains(compareTag)){
					tableData = textParser.makeXmlTagSafe(tableData);
					template = template.replace(compareString, tableData);
				}
//				if(template.contains(compareCloseTag)){
//					tableData = textParser.makeXmlTagSafe(tableData);
//					template = template.replace(compareString, tableData);
//				}
				else if(template.contains(compareString)){
					tableData = textParser.makeXmlValueSafe(tableData);
					template = template.replace(compareString, tableData);
				}

			}
		}	


		return template;

	}

	public String convertFromTemplate(HtmlTable table, String xmlTemplate){
		String template = xmlTemplate;	

		//iterate the length of the tables rows and columns and replace the tags and values where necessary
		List<HtmlTableRow> list = table.getRows();
		for(int i = 0; i<list.size(); i++){
			HtmlTableRow row = list.get(i);

			List<HtmlTableCell> cells = row.getCells();
			for(int j = 0; j<cells.size(); j++){
				HtmlTableCell cell = cells.get(j);
				logger.info("   Found cell: " + i +", "+j+": " + cell.asText());
				String tableData = cell.asText();
				String compareString = "row"+i+"col"+j+"<";	//we need to add in the angle bracket here to unsure larger numbers are not broken TODO: fix properly
				String compareTag = "<row"+i+"col"+j+">";	
				String compareCloseTag = "</row"+i+"col"+j+">";
				String compareChildTag="<row"+i+"col"+j+"child";
				String compareAttributeTag = "<row"+i+"col"+j+" attribute='alt'>";
				String compareClaseAttributeTag = "</row"+i+"col"+j+" attribute='alt'>";
				String compareAttributeValue = "row"+i+"col"+j+" attribute='alt'";
				String compareChildValue = "row"+i+"col"+j+"child";
				
				if(template.contains(compareTag)){
					tableData = textParser.makeXmlTagSafe(tableData);
					template = template.replace(compareTag, "<"+tableData+">");
					//TODO: if the template has been validated we should not need to check for both tags
					if(template.contains(compareCloseTag)){
						tableData = textParser.makeXmlTagSafe(tableData);
						template = template.replace(compareCloseTag, "</"+tableData+">");
					}
				}
				if(template.contains(compareString)){
					tableData = textParser.makeXmlValueSafe(tableData);
					compareString = compareString.substring(0, compareString.length());
					template = template.replace(compareString, tableData+"<");
				}
				
				if(template.contains(compareAttributeTag)){
					if(cell.hasAttribute("alt")){
						String altString = cell.getAttribute("alt");
						altString = textParser.makeXmlTagSafe(altString);
						template = template.replace(compareAttributeTag, "<"+altString+">");
						template = template.replace(compareClaseAttributeTag,"</"+altString+">");
					}
				}
				if(template.contains(compareAttributeValue)){
					logger.info("FOUND MATCHING ATTRIBUTE");
					logger.info("checking child nodes:");
					if(cell.hasChildNodes()){
						DomNodeList<DomNode> c = cell.getChildNodes();
						logger.info("has child nodes: " +c.getLength());
						for (DomNode domNode : c) {
							logger.info(domNode.asText());
						}
					}
					logger.info("checking attributes: ");
					if(cell.hasAttributes()){
						NamedNodeMap atts = cell.getAttributes();
						for(int y =0; y<atts.getLength(); y++){
							logger.info("attribute: " +atts.item(y).getTextContent());
						}
					}
					if(cell.hasAttribute("alt")){
						logger.info("CELL HAS ATTRIBUTE");
						String altString = cell.getAttribute("alt");
						template = template.replace(compareAttributeTag, altString);
					}else {
						logger.info("CELL DOES NOT HAVE ATTRIBUTE");
					}
					
				}
				
				if(template.contains(compareChildValue)){
					if(cell.hasChildNodes()){
						DomNodeList<DomNode> x = cell.getChildNodes();
						for(int k = 0; k<x.getLength(); k++){
							String compareAttValue="row"+i+"col"+j+"child"+k+" attribute='alt'";
							String compareAttribute = "<row"+i+"col"+j+"child"+k+" attribute='alt'>"; // only one supported
							
							if(template.contains(compareAttValue)){
								DomNode domNode = (DomNode) x.item(k);
								if(domNode.hasAttributes()){
									NamedNodeMap y = domNode.getAttributes();
									if(y!=null){
										String att = y.getNamedItem("alt").getNodeValue();
										if(template.contains(compareAttribute)){
											att = textParser.makeXmlTagSafe(att);

										}else{
											att = textParser.makeXmlValueSafe(att);
										}
										template = template.replace(compareAttValue, att);

									}
								}
							}
						}
					}
				}
				
				else if(template.contains(compareChildTag)){
					if(cell.hasChildNodes()){
						DomNodeList<DomNode> x = cell.getChildNodes();
						for(int k = 0; k<x.getLength(); k++){
							String compareAttValue="row"+i+"col"+j+"child"+k+" attribute='alt'";
							String compareAttribute = "<row"+i+"col"+j+"child"+k+" attribute='alt'>"; // only one supported
							
							if(template.contains(compareAttValue)){
								DomNode domNode = (DomNode) x.item(k);
								if(domNode.hasAttributes()){
									NamedNodeMap y = domNode.getAttributes();
									if(y!=null){
										String att = y.getNamedItem("alt").getNodeValue();
										if(template.contains(compareAttribute)){
											att = textParser.makeXmlTagSafe(att);

										}else{
											att = textParser.makeXmlValueSafe(att);
										}
										template = template.replace(compareAttValue, att);

									}
								}
							}
						}
					}
				}

			

				

			}
		}	


		return template;

	}



	/*
	 * just for testing
	 */
//	public void printTable(HtmlTable table){
//
//		//iterate the length of the tables rows and columns and replace the tags and values where necessary
//		List<HtmlTableRow> list = table.getRows();
//		for(int i = 0; i<list.size(); i++){
//			HtmlTableRow row = list.get(i);
//
//			List<HtmlTableCell> cells = row.getCells();
//			for(int j = 0; j<cells.size(); j++){
//				HtmlTableCell cell = cells.get(j);
//				logger.info("   Found cell: " + i +", "+j+": " + cell.asText());
//
//
//			}
//		}
//	}

	public static void main(String[] args){
		//		String testTemplate = "<row1col0><row1col1>row2col1</row1col1></row1col0>";
	}

}
